/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.menu.services;

import com.atlassian.failurecache.Cache;
import com.atlassian.failurecache.CacheFactory;
import com.atlassian.failurecache.CacheLoader;
import com.atlassian.failurecache.Cacheable;
import com.atlassian.failurecache.Refreshable;
import com.atlassian.plugins.navlink.consumer.menu.services.NavigationLinksCacheLoader;
import com.atlassian.plugins.navlink.consumer.menu.services.RemoteNavigationLinkService;
import com.atlassian.plugins.navlink.producer.navigation.ApplicationNavigationLinks;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.atlassian.plugins.navlink.util.executor.DaemonExecutorService;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class CachingRemoteNavigationLinkServiceImpl
implements Cacheable,
InitializingBean,
Runnable,
Refreshable,
RemoteNavigationLinkService {
    private static final long INITIAL_DELAY_IN_SECONDS = Long.getLong("navlink.navigationlinkscache.initialdelay", 35L);
    private static final long DELAY_IN_SECONDS = Long.getLong("navlink.navigationlinkscache.delay", 10L);
    private static final Logger logger = LoggerFactory.getLogger(CachingRemoteNavigationLinkServiceImpl.class);
    private final NavigationLinksCacheLoader navigationLinksCacheLoader;
    private final Cache<ApplicationNavigationLinks> cache;
    private final DaemonExecutorService executorService;

    public CachingRemoteNavigationLinkServiceImpl(NavigationLinksCacheLoader navigationLinksCacheLoader, DaemonExecutorService executorService, CacheFactory cacheFactory) {
        this.navigationLinksCacheLoader = navigationLinksCacheLoader;
        this.cache = cacheFactory.createExpirationDateBasedCache((CacheLoader)navigationLinksCacheLoader);
        this.executorService = executorService;
    }

    @Override
    @Nonnull
    public Set<NavigationLink> all(@Nonnull Locale locale) {
        return this.matching(locale, (Predicate<NavigationLink>)Predicates.alwaysTrue());
    }

    @Override
    @Nonnull
    public Set<NavigationLink> matching(@Nonnull Locale locale, @Nullable Predicate<NavigationLink> criteria) {
        Iterable<ApplicationNavigationLinks> applicationNavigationLinksForLocale = this.filterCacheByLocale(locale);
        Iterable navigationLinkSetsForLocale = Iterables.transform(applicationNavigationLinksForLocale, this.extractNavigationLinkSets());
        Iterable navigationLinksForLocale = Iterables.concat((Iterable)navigationLinkSetsForLocale);
        Iterable filteredNavigationLinksForLocale = Iterables.filter((Iterable)navigationLinksForLocale, criteria);
        return ImmutableSet.copyOf((Iterable)filteredNavigationLinksForLocale);
    }

    @Override
    public void run() {
        this.refreshCache();
    }

    public int getCachePriority() {
        return 700;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public ListenableFuture<?> refreshCache() {
        try {
            return this.cache.refresh();
        }
        catch (Exception e) {
            logger.debug("Failed to refresh remote menu items cache", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService.scheduleWithFixedDelay(this, INITIAL_DELAY_IN_SECONDS, DELAY_IN_SECONDS, TimeUnit.SECONDS);
    }

    private Iterable<ApplicationNavigationLinks> filterCacheByLocale(Locale mostSpecificLocale) {
        ImmutableSet cacheValues = ImmutableSet.copyOf((Iterable)this.cache.getValues());
        Collection expectedCacheHit = Collections2.filter((Collection)cacheValues, this.filterByLocale(mostSpecificLocale));
        if (!expectedCacheHit.isEmpty()) {
            return expectedCacheHit;
        }
        this.navigationLinksCacheLoader.cacheMissFor(mostSpecificLocale);
        Locale sameLanguage = new Locale(mostSpecificLocale.getLanguage());
        return this.filterWithFallBack((ImmutableSet<ApplicationNavigationLinks>)cacheValues, this.filterByLanguage(sameLanguage), this.filterByLanguage(Locale.ENGLISH));
    }

    private Iterable<ApplicationNavigationLinks> filterWithFallBack(ImmutableSet<ApplicationNavigationLinks> cacheValues, Predicate<ApplicationNavigationLinks> ... filterFunctions) {
        for (Predicate<ApplicationNavigationLinks> filterFunction : filterFunctions) {
            Collection applicationNavigationLinksForLocale = Collections2.filter(cacheValues, filterFunction);
            if (applicationNavigationLinksForLocale.isEmpty()) continue;
            return applicationNavigationLinksForLocale;
        }
        return Collections.emptySet();
    }

    private Predicate<ApplicationNavigationLinks> filterByLocale(final Locale locale) {
        return new Predicate<ApplicationNavigationLinks>(){

            public boolean apply(@Nullable ApplicationNavigationLinks input) {
                return input != null && input.getLocale().equals(locale);
            }
        };
    }

    private Predicate<ApplicationNavigationLinks> filterByLanguage(Locale locale) {
        final String language = locale.getLanguage();
        return new Predicate<ApplicationNavigationLinks>(){

            public boolean apply(@Nullable ApplicationNavigationLinks input) {
                return input != null && input.getLocale().getLanguage().equals(language);
            }
        };
    }

    private Function<ApplicationNavigationLinks, ImmutableSet<NavigationLink>> extractNavigationLinkSets() {
        return new Function<ApplicationNavigationLinks, ImmutableSet<NavigationLink>>(){

            public ImmutableSet<NavigationLink> apply(@Nullable ApplicationNavigationLinks from) {
                return from != null ? from.getNavigationLinks() : ImmutableSet.of();
            }
        };
    }
}

