/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.menu.client.capabilities;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.failurecache.ExpiringValue;
import com.atlassian.plugins.navlink.consumer.http.HttpRequestFactory;
import com.atlassian.plugins.navlink.consumer.menu.client.capabilities.CapabilitiesClient;
import com.atlassian.plugins.navlink.consumer.menu.client.capabilities.CapabilitiesResponseHandler;
import com.atlassian.plugins.navlink.consumer.menu.client.capabilities.CapabilitiesRestResourceUrlFactory;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilities;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class RestCapabilitiesClient
implements CapabilitiesClient,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(RestCapabilitiesClient.class);
    private final HttpRequestFactory requestFactory;
    private final ListeningExecutorService executor;

    public RestCapabilitiesClient(HttpRequestFactory requestFactory) {
        this(requestFactory, MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(ThreadFactories.namedThreadFactory((String)"NavLink RestCapabilitiesClient"))));
    }

    @VisibleForTesting
    RestCapabilitiesClient(HttpRequestFactory requestFactory, ListeningExecutorService executor) {
        this.requestFactory = requestFactory;
        this.executor = executor;
    }

    @Override
    public ListenableFuture<ExpiringValue<RemoteApplicationWithCapabilities>> getCapabilities(ReadOnlyApplicationLink applicationLink) {
        String requestUrl = CapabilitiesRestResourceUrlFactory.createRequestUrl(applicationLink);
        logger.debug("Scheduling request for capabilities from '{}' (application link id: {})", (Object)requestUrl, (Object)applicationLink.getId());
        return this.scheduleRequest(requestUrl, new CapabilitiesResponseHandler(applicationLink));
    }

    public void destroy() throws Exception {
        this.executor.shutdownNow();
    }

    private ListenableFuture<ExpiringValue<RemoteApplicationWithCapabilities>> scheduleRequest(final String requestUrl, final CapabilitiesResponseHandler responseHandler) {
        return this.executor.submit((Callable)new Callable<ExpiringValue<RemoteApplicationWithCapabilities>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ExpiringValue<RemoteApplicationWithCapabilities> call() throws Exception {
                long before = System.currentTimeMillis();
                try {
                    ExpiringValue<RemoteApplicationWithCapabilities> expiringValue = RestCapabilitiesClient.this.submitRequest(requestUrl, responseHandler);
                    return expiringValue;
                }
                finally {
                    logger.debug("Capabilities from '{}' have been fetched in {} ms", (Object)requestUrl, (Object)(System.currentTimeMillis() - before));
                }
            }
        });
    }

    @VisibleForTesting
    ExpiringValue<RemoteApplicationWithCapabilities> submitRequest(String requestUrl, CapabilitiesResponseHandler responseHandler) {
        try {
            return this.requestFactory.executeGetRequest(requestUrl, responseHandler);
        }
        catch (Exception e) {
            return this.handleException(requestUrl, e);
        }
    }

    private ExpiringValue<RemoteApplicationWithCapabilities> handleException(String requestUrl, Exception e) {
        logger.info("Failed to request capabilities from '{}': {}", (Object)requestUrl, (Object)e.getMessage());
        logger.debug("Stacktrace: ", (Throwable)e);
        return ExpiringValue.expiredNullValue();
    }
}

