/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.util.url;

import com.atlassian.plugins.navlink.util.url.UrlFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.HttpServletRequest;

@Immutable
public class BaseUrl {
    private static final Map<String, Integer> DEFAULT_PORTS = ImmutableMap.of((Object)"http", (Object)80, (Object)"https", (Object)443);
    private final String baseUrl;

    public BaseUrl(@Nonnull String baseUrl) {
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl);
    }

    @Nonnull
    public static BaseUrl extractFrom(HttpServletRequest request) {
        Preconditions.checkNotNull((Object)request);
        String scheme = Strings.nullToEmpty((String)request.getScheme());
        String serverName = Strings.nullToEmpty((String)request.getServerName());
        int port = BaseUrl.isDefaultPort(scheme, request.getServerPort()) ? -1 : request.getServerPort();
        String contextPath = Strings.nullToEmpty((String)request.getContextPath());
        try {
            return BaseUrl.createBaseUrl(scheme, serverName, port, contextPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to extract a valid url from the request", e);
        }
    }

    public static BaseUrl fromSystemProperty(String key, @Nullable String def) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)def, (Object)"def");
        return new BaseUrl(System.getProperty(key, def));
    }

    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String resolve(@Nullable String path) {
        return UrlFactory.toAbsoluteUrl(this.baseUrl, Strings.nullToEmpty((String)path));
    }

    @Nonnull
    private static BaseUrl createBaseUrl(String scheme, String serverName, int port, String contextPath) throws MalformedURLException {
        return new BaseUrl(new URL(scheme, serverName, port, contextPath).toExternalForm());
    }

    private static boolean isDefaultPort(@Nonnull String scheme, int port) {
        Integer defaultPort = DEFAULT_PORTS.get(scheme.toLowerCase());
        return defaultPort != null && defaultPort == port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseUrl other = (BaseUrl)o;
        return this.baseUrl.equals(other.baseUrl);
    }

    public int hashCode() {
        return this.baseUrl.hashCode();
    }

    public String toString() {
        return "BaseUrl{" + this.baseUrl + '}';
    }
}

