/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.util.i18n;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class LocaleSupportingI18nResolverWorkAround {
    private final I18nResolver i18nResolver;

    public LocaleSupportingI18nResolverWorkAround(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Nonnull
    public String getText(@Nonnull Locale locale, @Nullable String key) {
        Preconditions.checkNotNull((Object)locale);
        return key != null ? Strings.nullToEmpty((String)this.translateKey(key, locale)) : "";
    }

    @Nonnull
    public String getText(@Nonnull Locale locale, @Nullable String key, Serializable ... arguments) {
        Preconditions.checkNotNull((Object)locale);
        Preconditions.checkNotNull((Object)arguments);
        String pattern = this.getText(locale, key);
        try {
            return MessageFormat.format(pattern, arguments);
        }
        catch (RuntimeException e) {
            return pattern;
        }
    }

    @Nullable
    private String translateKey(@Nonnull String key, @Nonnull Locale locale) {
        return StringUtils.defaultIfEmpty((String)((String)this.i18nResolver.getAllTranslationsForPrefix(key, locale).get(key)), (String)key);
    }
}

