/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.menu.services;

import com.atlassian.applinks.api.ApplicationLink;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public enum IgnoreRemotePluginApplicationLinkPredicate implements Predicate<ApplicationLink>
{
    INSTANCE;

    private static final String MAGIC_PROPERTY = "IS_ACTIVITY_ITEM_PROVIDER";

    public boolean apply(@Nullable ApplicationLink input) {
        return input != null && this.hasMagicPropertySetToFalse(input);
    }

    private boolean hasMagicPropertySetToFalse(@Nonnull ApplicationLink applicationLink) {
        String propertyValue = this.getStringProperty(applicationLink, MAGIC_PROPERTY);
        return propertyValue != null && propertyValue.equalsIgnoreCase(Boolean.FALSE.toString());
    }

    @Nullable
    private String getStringProperty(@Nonnull ApplicationLink applicationLink, @Nonnull String propertyKey) {
        Object value = applicationLink.getProperty(propertyKey);
        return value != null && value instanceof String ? (String)String.class.cast(value) : null;
    }
}

