/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.menu.services;

import com.atlassian.plugins.custom_apps.api.CustomApp;
import com.atlassian.plugins.custom_apps.api.CustomAppService;
import com.atlassian.plugins.navlink.consumer.menu.services.MaskBitbucketNavigationLinkTransformer;
import com.atlassian.plugins.navlink.consumer.menu.services.MenuService;
import com.atlassian.plugins.navlink.consumer.menu.services.NavigationLinkComparator;
import com.atlassian.plugins.navlink.consumer.menu.services.RemoteNavigationLinkService;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLinkBuilder;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLinkPredicates;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLinks;
import com.atlassian.plugins.navlink.producer.navigation.services.LocalNavigationLinkService;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DefaultMenuService
implements MenuService {
    private final LocalNavigationLinkService localNavigationLinkService;
    private final RemoteNavigationLinkService remoteNavigationLinkService;
    private final CustomAppService customAppService;
    private final UserManager userManager;

    public DefaultMenuService(LocalNavigationLinkService localNavigationLinkService, RemoteNavigationLinkService remoteNavigationLinkService, CustomAppService customAppService, UserManager userManager) {
        this.localNavigationLinkService = localNavigationLinkService;
        this.remoteNavigationLinkService = remoteNavigationLinkService;
        this.customAppService = customAppService;
        this.userManager = userManager;
    }

    @Override
    @Nonnull
    public Iterable<NavigationLink> getMenuItems(@Nonnull String key, String userName, @Nonnull Locale locale) {
        Set<NavigationLink> localNavigationLinks = this.getLocalNavigationLinks(key, locale);
        Set<NavigationLink> remoteNavigationLinks = this.getRemoteNavigationLinks(key, locale);
        return this.mergeNavigationLinks(localNavigationLinks, remoteNavigationLinks);
    }

    @Override
    @Nonnull
    public Iterable<NavigationLink> getAppSwitcherItems(String userName) {
        List<CustomApp> apps = this.getVisibleLocalCustomAppsAndRemoteLinks(userName);
        ArrayList menu = Lists.newArrayListWithCapacity((int)apps.size());
        for (CustomApp customApp : apps) {
            menu.add(((NavigationLinkBuilder)NavigationLinks.copyOf(customApp).key("home")).build());
        }
        return menu;
    }

    @Nonnull
    private List<CustomApp> getVisibleLocalCustomAppsAndRemoteLinks(@Nullable String userName) {
        List<CustomApp> localAndRemoteLinks = this.customAppService.getLocalCustomAppsAndRemoteLinks();
        Iterable localAndRemoteLinksVisibleToUser = Iterables.filter(localAndRemoteLinks, this.isVisibleForUser(userName));
        return Lists.newArrayList((Iterable)localAndRemoteLinksVisibleToUser);
    }

    @Nonnull
    private Predicate<CustomApp> isVisibleForUser(final String userName) {
        return new Predicate<CustomApp>(){

            public boolean apply(@Nullable CustomApp input) {
                return input != null && !input.getHide() && DefaultMenuService.this.visibleToCurrentUser(input, userName);
            }
        };
    }

    public boolean visibleToCurrentUser(CustomApp customApp, @Nullable String userName) {
        if (customApp.getAllowedGroups().isEmpty()) {
            return true;
        }
        if (StringUtils.isBlank((String)userName)) {
            return false;
        }
        for (String groupName : customApp.getAllowedGroups()) {
            if (!this.userManager.isUserInGroup(userName, groupName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAppSwitcherVisibleForUser(@Nullable String userName) {
        List<CustomApp> localAndRemoteLinks = this.customAppService.getLocalCustomAppsAndRemoteLinks();
        return Iterables.any(localAndRemoteLinks, (Predicate)Predicates.and((Predicate)Predicates.not(this.isSelfLink()), this.isVisibleForUser(userName)));
    }

    @Nonnull
    private Predicate<CustomApp> isSelfLink() {
        return new Predicate<CustomApp>(){

            public boolean apply(@Nullable CustomApp customApp) {
                return customApp != null && customApp.isSelf();
            }
        };
    }

    @Nonnull
    private Set<NavigationLink> getLocalNavigationLinks(@Nonnull String key, @Nonnull Locale locale) {
        return this.localNavigationLinkService.matching(locale, NavigationLinkPredicates.keyEquals(key));
    }

    @Nonnull
    private Set<NavigationLink> getRemoteNavigationLinks(@Nonnull String key, @Nonnull Locale locale) {
        Set<NavigationLink> matches = this.remoteNavigationLinkService.matching(locale, NavigationLinkPredicates.keyEquals(key));
        return Sets.newHashSet((Iterable)Iterables.transform(matches, (Function)new Function<NavigationLink, NavigationLink>(){

            public NavigationLink apply(@Nullable NavigationLink remoteLink) {
                return remoteLink != null ? NavigationLinkBuilder.copyOf(remoteLink).build() : null;
            }
        }));
    }

    @Nonnull
    private List<NavigationLink> mergeNavigationLinks(@Nonnull Iterable<NavigationLink> localNavigationLinks, @Nonnull Iterable<NavigationLink> remoteNavigationLinks) {
        Iterable navigationLinks = Iterables.concat(localNavigationLinks, remoteNavigationLinks);
        Iterable processedNavigationLinks = Iterables.transform((Iterable)navigationLinks, (Function)MaskBitbucketNavigationLinkTransformer.INSTANCE);
        ArrayList result = Lists.newArrayList((Iterable)processedNavigationLinks);
        Collections.sort(result, NavigationLinkComparator.INSTANCE);
        return result;
    }
}

