package com.atlassian.plugins.navlink.util;

import org.apache.commons.lang.StringEscapeUtils;

import javax.annotation.Nullable;

/**
 * Encode {@link String}s to put them into a JSON document.
 */
public class JsonStringEncoder
{
    /**
     * Encode the given str by escaping quotes. The method name should prevent velocity auto escaping.
     * @param str the string to be escaped
     * @return the escaped string or <code>null</code> if the str was null
     */
    @Nullable
    public String asHtml(@Nullable final String str)
    {
        return StringEscapeUtils.escapeJava(str);
    }
}
