package com.atlassian.plugins.navlink.util;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;

import java.util.Set;

public class IsUserAdminFunction implements SoyServerFunction<Boolean>, SoyClientFunction
{
    private UserManager userManager;

    public IsUserAdminFunction(UserManager userManager)
    {
        this.userManager = userManager;
    }

    @Override
    public String getName()
    {
        return "isUserAdmin";
    }

    /**
     * Required for soy compiler. We use this function server side only.
     */
    @Override
    public JsExpression generate(JsExpression... args)
    {
        return new JsExpression("false");
    }

    @Override
    public Boolean apply(Object... args)
    {
        return userManager.isAdmin(userManager.getRemoteUsername());
    }

    @Override
    public Set<Integer> validArgSizes()
    {
        return ImmutableSet.of(0);
    }
}
