package com.atlassian.plugins.navlink.producer.navigation.services;

import com.atlassian.plugins.navlink.producer.navigation.links.NavigationLinkBuilderBase;

public class RawNavigationLinkBuilder extends NavigationLinkBuilderBase<RawNavigationLinkBuilder,RawNavigationLink>
{
    public static RawNavigationLinkBuilder copyOf(RawNavigationLink that)
    {
        return new RawNavigationLinkBuilder().copy(that);
    }

    String labelKey;
    String tooltipKey;

    public RawNavigationLinkBuilder()
    {
        super(RawNavigationLinkBuilder.class);
    }

    public RawNavigationLinkBuilder copy(RawNavigationLink that)
    {
        return super.copy(that)
                .labelKey(that.getLabelKey())
                .tooltipKey(that.getTooltipKey());
    }

    public RawNavigationLinkBuilder setLabelKey(String labelKey)
    {
        this.labelKey = labelKey;
        return this;
    }

    public RawNavigationLinkBuilder labelKey(String labelKey)
    {
        return setLabelKey(labelKey);
    }

    public RawNavigationLinkBuilder setHref(String href)
    {
        return href(href);
    }

    public RawNavigationLinkBuilder setTooltipKey(String tooltipKey)
    {
        this.tooltipKey = tooltipKey;
        return this;
    }

    public RawNavigationLinkBuilder tooltipKey(String tooltipKey)
    {
        return setTooltipKey(tooltipKey);
    }

    public RawNavigationLinkBuilder setIcon(String icon)
    {
        return iconUrl(icon);
    }

    public RawNavigationLink createLocalNavigationLink()
    {
        return new RawNavigationLink(this);
    }

    public RawNavigationLink build()
    {
        return createLocalNavigationLink();
    }
}