package com.atlassian.plugins.navlink.producer.navigation.services;

import javax.annotation.Nonnull;
import java.util.Set;

/**
 * Returns all navigation links defined by the application itself or one of the hosted plugins.
 *
 * @see LocalNavigationLinkService
 * @since 1.0
 */
public interface LocalNavigationLinks
{
    /**
     * Retrieves all the navigation links defined for the host application.
     *
     * @return An {@link Iterable} containing all the raw navigation links defined for the host application.
     */
    @Nonnull
    Set<RawNavigationLink> all();
}
