package com.atlassian.plugins.navlink.producer.navigation;

import com.atlassian.plugins.navlink.producer.navigation.links.NavigationLinkBuilderBase;

import javax.annotation.Nonnull;

/**
 * Builder class for {@link com.atlassian.plugins.navlink.producer.navigation.NavigationLink}s
 *
 * @since 2.2.3
 */
public final class NavigationLinkBuilder extends NavigationLinkBuilderBase<NavigationLinkBuilder,NavigationLink>
{

    public static NavigationLinkBuilder copyOf(NavigationLink original)
    {
        return new NavigationLinkBuilder()
                .copy(original)
                .label(original.getLabel())
                .tooltip(original.getTooltip());
    }

    String label;
    String tooltip;


    public NavigationLinkBuilder()
    {
        super(NavigationLinkBuilder.class);
    }

    @Nonnull
    public NavigationLinkBuilder label(String label)
    {
        this.label = label;
        return this;
    }

    @Nonnull
    public NavigationLinkBuilder tooltip(String tooltip)
    {
        this.tooltip = tooltip;
        return this;
    }

    @Nonnull
    public NavigationLink build()
    {
        return new NavigationLink(this);
    }

}
