package com.atlassian.plugins.navlink.producer.navigation;

import com.atlassian.plugins.navlink.producer.navigation.links.NavigationLinkBase;
import com.google.common.base.Objects;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class NavigationLink extends NavigationLinkBase
{
    private final String label;
    private final String tooltip;

    NavigationLink(NavigationLinkBuilder builder)
    {
        super(builder);
        this.label = builder.label != null ? builder.label : "";
        this.tooltip = builder.tooltip;
    }

    public String getLabel()
    {
        return label;
    }

    public String getTooltip()
    {
        return tooltip;
    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(hashCodeBase(), label, tooltip);
    }

    @Override
    public boolean equals(final Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        else if (!(obj instanceof NavigationLink))
        {
            return false;
        }
        final NavigationLink that = (NavigationLink) obj;
        return isEqualTo(that) &&
                Objects.equal(label, that.label) &&
                Objects.equal(tooltip, that.tooltip);
    }

    @Override
    public String toString()
    {
        return "NavigationLink{" + toStringBase() +
            ", label='" + label + '\'' +
            ", tooltip='" + tooltip + '\'' +
            '}';
    }
}
