package com.atlassian.plugins.navlink.consumer.menu.services;

import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;

import java.util.Comparator;
import java.util.List;

/**
 * Legacy nav link comparator for use when the involved products do not yet
 * implement weights in the navigation API.
 *
 * TODO ROTP-783: remove once not needed any more
 *
 * @since v5.0
 */
final class LegacyNavLinkComparator implements Comparator<NavigationLink>
{

    static final LegacyNavLinkComparator INSTANCE = new LegacyNavLinkComparator();

    public static final String APPLICATION_TYPE_BAMBOO = "bamboo";
    public static final String APPLICATION_TYPE_BITBUCKET = "bitbucket";
    public static final String APPLICATION_TYPE_CONFLUENCE = "confluence";
    public static final String APPLICATION_TYPE_FECRU = "fecru";
    public static final String APPLICATION_TYPE_HIPCHAT = "hipchat";
    public static final String APPLICATION_TYPE_JIRA = "jira";
    public static final String APPLICATION_TYPE_STASH = "stash";

    private List<String> orderedAppTypes = ImmutableList.of(
            APPLICATION_TYPE_JIRA,
            APPLICATION_TYPE_CONFLUENCE,
            APPLICATION_TYPE_STASH,
            APPLICATION_TYPE_BITBUCKET,
            APPLICATION_TYPE_BAMBOO,
            APPLICATION_TYPE_FECRU,
            APPLICATION_TYPE_HIPCHAT
    );

    @Override
    public int compare(NavigationLink o1, NavigationLink o2)
    {
        if (o1 == o2) return 0;

        int comparison = compareAppTypes(o1.getApplicationType(), o2.getApplicationType());
        if (comparison == 0) comparison = compareStrings(o1.getLabel(), o2.getLabel());
        if (comparison == 0) comparison = compareStrings(o1.getHref(), o2.getHref());

        return comparison;
    }

    private int compareAppTypes(String applicationType1, String applicationType2)
    {
        int index1 = orderedAppTypes.indexOf(normalizeApplicationType(applicationType1));
        int index2 = orderedAppTypes.indexOf(normalizeApplicationType(applicationType2));

        if (index1 == -1 && index2 == -1)
        {
            if (applicationType1 != null && applicationType2 != null)
                return compareStrings(applicationType1, applicationType2);
            if (applicationType1 == null && applicationType2 == null) return 0;
            if (applicationType1 == null) return 1;
            if (applicationType2 == null) return -1;
        }
        if (index1 == -1) return 1;
        if (index2 == -1) return -1;
        if (index1 < index2) return -1;
        if (index1 > index2) return 1;
        return 0;
    }

    private String normalizeApplicationType(String applicationType)
    {
        return Strings.nullToEmpty(applicationType).replace("FishEye / Crucible", "fecru").toLowerCase();
    }

    private int compareStrings(String string1, String string2)
    {
        int i = string1.compareTo(string2);
        if (i==0) return 0;
        return i < 0 ? -1 : 1;
    }

}
