package com.atlassian.plugins.navlink.consumer.menu.client.navigation;

import com.atlassian.plugins.navlink.producer.capabilities.CapabilityKey;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilities;
import com.atlassian.plugins.navlink.producer.navigation.rest.LanguageParameter;
import org.apache.commons.lang.StringUtils;

import javax.annotation.Nullable;
import java.util.Locale;

public class NavigationRestResourceUrlFactory
{
    /**
     * Returns the proper request url to access the navigation capabilities of the remote application.
     * @param application the remote application from which the navigation capability is requested
     * @param locale the preferred locale in which the content should be returned
     * @return the request url to which the request should be send
     */
    @Nullable
    public static String createRequestUrl(final RemoteApplicationWithCapabilities application, final Locale locale)
    {
        final String capabilityUrl = StringUtils.trimToNull(application.getCapabilityUrl(CapabilityKey.NAVIGATION.getKey()));
        return capabilityUrl != null ? String.format("%s?lang=%s", capabilityUrl, LanguageParameter.encodeValue(locale)) : null;
    }
}
