package com.atlassian.plugins.navlink.consumer.menu.client.navigation;

import com.atlassian.failurecache.ExpiringValue;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilities;
import com.atlassian.plugins.navlink.producer.navigation.ApplicationNavigationLinks;
import com.google.common.util.concurrent.ListenableFuture;

import java.util.Locale;

/**
 * A client for retrieving navigation links from a remote application.
 */
public interface NavigationClient
{
    /**
     * Returns the navigation links provided by the remote application.
     *
     * @param application the remote application from which the navigation links are requested
     * @param locale the locale in which the navigation links are requested; if the remote application doesn't support
     *               the specified locale, the remote application's default language is used.
     * @return a future of the navigation links provided by the remote application
     */
    ListenableFuture<ExpiringValue<ApplicationNavigationLinks>> getNavigationLinks(RemoteApplicationWithCapabilities application, Locale locale);
}
