package com.atlassian.plugins.navlink.caching;

import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.navlink.consumer.CachingApplicationLinkService;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import com.atlassian.failurecache.CacheRefreshService;

import static com.google.common.base.Preconditions.checkNotNull;

public class ApplicationLinkChangeListener implements InitializingBean, DisposableBean
{
    private final EventPublisher eventPublisher;
    private final CacheRefreshService cacheRefreshService;
    private final CachingApplicationLinkService applicationLinkService;

    public ApplicationLinkChangeListener(final EventPublisher eventPublisher, final CacheRefreshService cacheRefreshService, final CachingApplicationLinkService applicationLinkService)
    {
        this.eventPublisher = checkNotNull(eventPublisher);
        this.cacheRefreshService = checkNotNull(cacheRefreshService);
        this.applicationLinkService = applicationLinkService;
    }


    @Override
    public void afterPropertiesSet() throws Exception
    {
        eventPublisher.register(this);
    }

    @Override
    public void destroy() throws Exception
    {
        eventPublisher.unregister(this);
    }

    @EventListener
    @SuppressWarnings("UnusedParameters")
    public void onApplicationLinkAdded(final ApplicationLinkAddedEvent event)
    {
        clearCaches();
    }

    @EventListener
    @SuppressWarnings("UnusedParameters")
    public void onApplicationLinkDeleted(final ApplicationLinkDeletedEvent event)
    {
        clearCaches();
    }

    @EventListener
    @SuppressWarnings("UnusedParameters")
    public void onApplicationLinkIdChanged(final ApplicationLinksIDChangedEvent event)
    {
        clearCaches();
    }

    @EventListener
    @SuppressWarnings({"UnusedParameters", "UnusedDeclaration"})
    public void onApplicationLinkDetailsChanged(final ApplicationLinkDetailsChangedEvent event)
    {
        applicationLinkService.clear();
    }

    private void clearCaches()
    {
        cacheRefreshService.refreshAll(true);
        applicationLinkService.clear();
    }
}
