package com.atlassian.plugins.custom_apps.upgrade;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collection;

/**
 * @since v2.7
 */
public class InitialiseCustomOrderFlagUpgradeTask implements PluginUpgradeTask
{
    private static final Logger log = LoggerFactory.getLogger(InitialiseCustomOrderFlagUpgradeTask.class);
    private static final String CUSTOM_APPS_AS_JSON = "com.atlassian.plugins.custom_apps.customAppsAsJSON";
    private static final String HAS_CUSTOM_ORDER = "com.atlassian.plugins.custom_apps.hasCustomOrder";
    private final PluginSettingsFactory pluginSettingsFactory;

    public InitialiseCustomOrderFlagUpgradeTask(PluginSettingsFactory pluginSettingsFactory)
    {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public int getBuildNumber()
    {
        return 1;
    }

    @Override
    public String getShortDescription()
    {
        return "Initialise the value of com.atlassian.plugins.custom_apps.hasCustomOrder";
    }

    @Override
    public Collection<Message> doUpgrade() throws Exception
    {
        log.info("Starting plugin upgrade");
        final PluginSettings globalSettings = pluginSettingsFactory.createGlobalSettings();
        final Object hasCustomOrder = globalSettings.get(HAS_CUSTOM_ORDER);
        if (hasCustomOrder == null)
        {
            // Initialise the flag
            if (globalSettings.get(CUSTOM_APPS_AS_JSON) == null)
            {
                log.info("Initialising flag to false");
                // If there are no cached custom apps, use default ordering
                globalSettings.put(HAS_CUSTOM_ORDER, "false");
            }
            else
            {
                log.info("Initialising flag to true");
                // Otherwise, the user may have potentially reordered the links so use custom ordering
                globalSettings.put(HAS_CUSTOM_ORDER, "true");
            }
        }

        return null;
    }

    @Override
    public String getPluginKey()
    {
        return "com.atlassian.plugins.atlassian-nav-links-plugin";
    }
}
