package com.atlassian.plugins.custom_apps.ui.deprecated;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugins.custom_apps.security.authentication.LoginPage;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Duplicated version of the AdminServlet used to provide backwards compatibility with the old app switcher.
 * TODO remove when the app-switcher.new darkfeature is removed.
 */
@Deprecated
public class AdminServlet extends HttpServlet
{
    private static final Logger log = LoggerFactory.getLogger(AdminServlet.class);

    private final WebResourceManager webResourceManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final WebSudoManager webSudoManager;
    private final LoginPage loginPage;

    public AdminServlet(final WebResourceManager webResourceManager, final SoyTemplateRenderer soyTemplateRenderer,
            final UserManager userManager, final I18nResolver i18nResolver,
            final WebSudoManager webSudoManager, final LoginPage loginPage)
    {
        this.webResourceManager = webResourceManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
        this.webSudoManager = webSudoManager;
        this.loginPage = loginPage;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        try
        {
            webSudoManager.willExecuteWebSudoRequest(req);

            if (!userManager.isAdmin(userManager.getRemoteUsername(req)))
            {
                loginPage.redirect(req, resp);
            }
            else
            {
                webResourceManager.requireResource("com.atlassian.plugins.atlassian-nav-links-plugin:custom-apps-admin-ui-resources-old");
                resp.setContentType("text/html");

                Map<String, Object> params = new HashMap<String, Object>();
                params.put("title", i18nResolver.getText("custom-apps.page.title"));
                params.put("description", i18nResolver.getText("custom-apps.page.description"));

                try
                {
                    resp.getWriter().print(soyTemplateRenderer.render(
                            "com.atlassian.plugins.atlassian-nav-links-plugin:custom-apps-admin-page-template",
                            "com.atlassian.plugins.custom_apps.ui.customAppsAdminPage",
                            params
                    ));
                }
                catch (SoyException e)
                {
                    log.error("Error rendering template", e);
                    resp.sendError(500, e.getMessage());
                }
            }
        }
        catch (final WebSudoSessionException wse)
        {
            webSudoManager.enforceWebSudoProtection(req, resp);
        }
    }
}
