package com.atlassian.plugins.custom_apps.api;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * The custom app service stores locally defined custom applications, i.e. (displayname, URL) pairs, *and*
 * records the order in which these local custom apps and remotely provided links should be displayed in the app
 * switcher.
 *
 * @since 1.0
 */
public interface CustomAppService
{
    /**
     * Get all local custom apps.
     *
     * @return all custom apps stored in the host application
     */
    @Nonnull
    List<CustomApp> getCustomApps();

    /**
     * @return a List of CustomApps including remote links for which we have defined an order and any new remote links,
     *  placed at the end
     */
    @Nonnull
    List<CustomApp> getLocalCustomAppsAndRemoteLinks();

    CustomApp get(String id) throws CustomAppNotFoundException;

    void delete(String id) throws CustomAppNotFoundException;

    CustomApp create(String displayName, String url, String baseUrl, boolean hide, List<String> newAllowedGroups) throws CustomAppsValidationException;

    /**
     * Update the content of an existing Custom App instance.
     * e.g. change one or more of the display name, url, hide status or allowed groups.
     * Changes are persisted and made available to other users.
     * @param id unique id of the instance to be updated.
     * @param newDisplayName the potentially changed display name.
     * @param newUrl the potentially changed url.
     * @param hide the potentially changed hide flag.
     * @param newAllowedGroups the potentially changed list of allowed groups.
     * @return
     * @throws CustomAppNotFoundException
     * @throws CustomAppsValidationException
     */
    CustomApp update(String id, String newDisplayName, String newUrl, boolean hide, List<String> newAllowedGroups) throws CustomAppNotFoundException, CustomAppsValidationException;

    void moveAfter(int idToMove, int idToMoveAfter) throws CustomAppNotFoundException;

    void moveToStart(int idToMove) throws CustomAppNotFoundException;
}
