package com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink;

import java.util.List;

public interface CustomContentLinkService extends CustomContentLinkProvider
{
    public CustomContentLink addCustomContentLink(CustomContentLink customContentLink) throws NoAdminPermissionException;
    
    public void removeCustomContentLink(CustomContentLink customContentLink) throws NoAdminPermissionException;

    /**
     * No permission check is done on this operation.
     *
     * @param id the id of the link to retreive
     * @return the CustomContentLink, or null if no such link exists.
     */
    public CustomContentLink getById(int id);

    /**
     * If the link does not exist, this method does nothing.
     *
     * @param id the id of the link to delete
     * @throws NoAdminPermissionException
     */
    public void removeById(int id) throws NoAdminPermissionException;

    /**
     * If the link does not exist, this method does nothing.
     *
     * @param newValue the link containing the id of the link to update, and the new values it should be given.
     * @throws NoAdminPermissionException
     */
    public void update(CustomContentLink newValue) throws NoAdminPermissionException;

    /**
     * Move a link so its sequence is after another link. Both links must have the same content key
     */
    public void moveAfter(int idToMove, int idToComeAfter) throws NoAdminPermissionException;

    /**
     * Move the link with the given id to the start of the list of links for its key
     */
    public void moveToStart(int id) throws NoAdminPermissionException;

    /**
     * Gets custom content links provided by plugins in the host application
     */
    public List<CustomContentLink> getPluginCustomContentLinks(String key);
}
