package com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink;

import com.google.common.base.Objects;

public class CustomContentLink
{
    private final String url;
    private final String label;
    private final String key;
    private final Integer id;
    private final Integer sequence;

    private CustomContentLink(Builder builder)
    {
        this.url = builder.url;
        this.label = builder.label;
        this.key = builder.key;
        this.id = builder.id;
        this.sequence = builder.sequence;
    }

    /**
     * The id of the link -- this is null in links which were not retrieved from the DB
     */
    public Integer getId()
    {
        return id;
    }

    public String getContentKey()
    {
        return key;
    }

    public String getLinkLabel()
    {
        return label;
    }

    public String getLinkUrl()
    {
        return url;
    }

    public Integer getSequence() {
        return sequence;
    }

    public int hashCode()
    {
        return Objects.hashCode(url, label, key, id);
    }

    public boolean equals(Object other)
    {
        if (other == this)
            return true;
        if (other == null)
            return false;

        if (getClass().equals(other.getClass()))
        {
            CustomContentLink entity = (CustomContentLink) other;
            return Objects.equal(url, entity.url) && Objects.equal(label, entity.label) &&
                    Objects.equal(key, entity.key) && Objects.equal(id, entity.id);
        }
        return false;
    }

    @Override
    public String toString()
    {
        return "CustomContentLink [id=" + id + ", url=" + url + ", label=" + label + ", key=" + key + "]";
    }

    public static Builder builder()
    {
        return new Builder();
    }
    public static class Builder
    {
        private String url;
        private String label;
        private String key;
        public Integer id;
        public Integer sequence;


        /**
         * Sets the URL parameter for the CustomContentLink object to build
         * @param url The url to place into the generated CustomContentLink.  This should be a relative URL
         *            that does NOT include the context path for links inside the application, or an absolute URL for
         *            links outside the application.  This should not be a relative URL that contains a context path.
         */
        public Builder url(String url)
        {
            this.url = url;
            return this;
        }

        public Builder label(String label)
        {
            this.label = label;
            return this;
        }

        public Builder key(String key)
        {
            this.key = key;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder sequence(int sequence) {
            this.sequence = sequence;
            return this;
        }

        public CustomContentLink build()
        {
            if (sequence == null) {
                sequence = 0;
            }
            return new CustomContentLink(this);
        }
    }
}
