package com.atlassian.plugins.capabilities.api;

import javax.annotation.Nonnull;

import java.util.Set;

/**
 * Represents the remote <em>Applications</em> linked to the product hosted in this instance.
 * 
 * @since 3.1.9
 */
public interface LinkedApplicationCapabilities
{
    /**
     * Find the set of LinkedApplications that are capable of the given capability.
     *  
     * @param capabilityKey - the capability key to check
     * @return A set of ApplicationLinked apps that expose the given capability
     */
    @Nonnull
    Set<? extends LinkedAppWithCapabilities> capableOf(@Nonnull String capabilityKey);
}