/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devstatus.vcs;

import com.atlassian.annotations.PublicApi;
import com.atlassian.devstatus.EventEntity;
import com.atlassian.devstatus.EventInitiator;
import com.atlassian.devstatus.JiraIssueEvent;
import com.atlassian.devstatus.Person;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.remote.annotation.Capability;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nullable;

@AsynchronousPreferred
@Capability(value="JiraCommitEvent")
@PublicApi
public class JiraCommitEvent
extends JiraIssueEvent {
    private Person author;
    private Date authorDate;
    private Date commitDate;
    private String commitMessage;
    private Person committer;
    private boolean mergeCommit;
    private Type type;

    @JsonCreator
    protected JiraCommitEvent() {
    }

    public JiraCommitEvent(EventInitiator initiator, EventEntity entity, Collection<String> issueKeys, Type type, @Nullable Date commitDate, boolean mergeCommit) {
        super(initiator, entity, issueKeys);
        this.commitDate = commitDate;
        this.type = type;
        this.mergeCommit = mergeCommit;
    }

    public JiraCommitEvent(EventInitiator initiator, EventEntity entity, Collection<String> issueKeys, Type type, @Nullable Date commitDate) {
        this(initiator, entity, issueKeys, type, commitDate, false);
    }

    public JiraCommitEvent(EventInitiator initiator, EventEntity entity, Collection<String> issueKeys, Type type) {
        this(initiator, entity, issueKeys, type, null);
    }

    public JiraCommitEvent(EventInitiator initiator, EventEntity entity, Collection<String> issueKeys, Type type, @Nullable Date commitDate, @Nullable Date authorDate, @Nullable Person committer, @Nullable Person author, boolean mergeCommit, String commitMessage) {
        super(initiator, entity, issueKeys);
        this.commitDate = commitDate;
        this.authorDate = authorDate;
        this.type = type;
        this.mergeCommit = mergeCommit;
        this.committer = committer;
        this.author = author;
        this.commitMessage = commitMessage;
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public Date getCommitDate() {
        return this.commitDate;
    }

    @Nullable
    public Person getCommitter() {
        return this.committer;
    }

    @Nullable
    public Person getAuthor() {
        return this.author;
    }

    @Nullable
    public Date getAuthorDate() {
        return this.authorDate;
    }

    public boolean isMergeCommit() {
        return this.mergeCommit;
    }

    @Nullable
    public String getCommitMessage() {
        return this.commitMessage;
    }

    public static class Builder {
        private EventInitiator initiator;
        private EventEntity entity;
        private Collection<String> issueKeys;
        private Type type;
        private Date commitDate;
        private Date authorDate;
        private boolean mergeCommit;
        private Person committer;
        private Person author;
        private String commitMessage;

        public Builder withEventInformation(EventInitiator initiator, EventEntity entity, Collection<String> issueKeys) {
            this.initiator = initiator;
            this.entity = entity;
            this.issueKeys = issueKeys;
            return this;
        }

        public Builder withInitiator(EventInitiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public Builder withEntity(EventEntity entity) {
            this.entity = entity;
            return this;
        }

        public Builder withIssueKeys(Collection<String> issueKeys) {
            this.issueKeys = ImmutableList.copyOf(issueKeys);
            return this;
        }

        public Builder withType(Type type) {
            this.type = type;
            return this;
        }

        public Builder withCommitDate(Date commitDate) {
            this.commitDate = new Date(commitDate.getTime());
            return this;
        }

        public Builder withAuthorDate(Date authorDate) {
            this.authorDate = new Date(authorDate.getTime());
            return this;
        }

        public Builder withMergeCommit(boolean mergeCommit) {
            this.mergeCommit = mergeCommit;
            return this;
        }

        public Builder withCommitter(Person committer) {
            this.committer = committer;
            return this;
        }

        public Builder withAuthor(Person author) {
            this.author = author;
            return this;
        }

        public Builder withCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public JiraCommitEvent build() {
            return new JiraCommitEvent(this.initiator, this.entity, this.issueKeys, this.type, this.commitDate, this.authorDate, this.committer, this.author, this.mergeCommit, this.commitMessage);
        }
    }

    public static enum Type {
        CREATE,
        DELETE;

    }
}

