/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.spi.util;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.connect.spi.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class Dom4jUtils {
    public static String getRequiredAttribute(Element e, String name) {
        String value = e.attributeValue(name);
        if (value == null) {
            throw new PluginParseException("Attribute '" + name + "' is required on '" + e.getName() + "'");
        }
        return value;
    }

    public static String getRequiredElementText(Element e, String name) {
        Element child = e.element(name);
        if (child == null) {
            throw new PluginParseException("Element '" + name + "' is required on '" + e.getName() + "'");
        }
        return child.getTextTrim();
    }

    public static URI getRequiredUriAttribute(Element e, String name) {
        String value = Dom4jUtils.getRequiredAttribute(e, name);
        return URI.create(value);
    }

    public static URI getOptionalUriAttribute(Element e, String name) {
        String value = e.attributeValue(name);
        return value != null ? URI.create(value) : null;
    }

    public static String getOptionalAttribute(Element e, String name, Object defaultValue) {
        String value = e.attributeValue(name);
        return value != null ? value : (defaultValue != null ? defaultValue.toString() : null);
    }

    public static List<Node> content(Document schema) {
        return schema.content();
    }

    public static Document parseDocument(URL xmlUrl) {
        Document source;
        try {
            source = XmlUtils.createSecureSaxReader().read(xmlUrl);
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Unable to parse XML", e);
        }
        return source;
    }

    public static String printNode(Node document) {
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
        try {
            xmlWriter.write(document);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to write node", e);
        }
        return writer.toString();
    }

    public static Document readDocument(ServletRequest request) {
        try {
            return Dom4jUtils.readDocument((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readDocument(InputStream in) {
        SAXReader build = XmlUtils.createSecureSaxReader();
        try {
            Document document = build.read(in);
            return document;
        }
        catch (DocumentException e) {
            Document document = null;
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

