/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.spi.permission.scope;

import com.atlassian.plugin.connect.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.connect.spi.util.Dom4jUtils;
import com.atlassian.plugin.connect.spi.util.ServletUtils;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;

public class XmlRpcApiScopeHelper {
    private final String path;
    private final Collection<String> methods;
    private final Iterable<ApiResourceInfo> apiResourceInfo;

    public XmlRpcApiScopeHelper(final String path, Collection<String> methods) {
        this.path = path;
        this.methods = methods;
        this.apiResourceInfo = Iterables.transform(methods, (Function)new Function<String, ApiResourceInfo>(){

            public ApiResourceInfo apply(String from) {
                return new ApiResourceInfo(path, "POST", from);
            }
        });
    }

    public boolean allow(HttpServletRequest request, String user) {
        String pathInfo = ServletUtils.extractPathInfo(request);
        if (this.path.equals(pathInfo)) {
            Document doc = Dom4jUtils.readDocument((ServletRequest)request);
            String method = doc.getRootElement().element("methodName").getTextTrim();
            if (method == null) {
                return false;
            }
            if (this.methods.contains(method)) {
                return true;
            }
        }
        return false;
    }

    public Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }
}

