/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.spi.permission.scope;

import com.atlassian.plugin.connect.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.connect.spi.util.Dom4jUtils;
import com.atlassian.plugin.connect.spi.util.ServletUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.dom4j.Element;

public final class RpcEncodedSoapApiScopeHelper {
    private final String path;
    private final Collection<SoapScope> soapActions;
    private final Iterable<ApiResourceInfo> apiResourceInfo;

    public RpcEncodedSoapApiScopeHelper(final String path, Collection<SoapScope> soapActions) {
        this.path = path;
        this.soapActions = soapActions;
        this.apiResourceInfo = Iterables.transform(soapActions, (Function)new Function<SoapScope, ApiResourceInfo>(){

            public ApiResourceInfo apply(SoapScope from) {
                return new ApiResourceInfo(path, "POST", from.name);
            }
        });
    }

    public RpcEncodedSoapApiScopeHelper(String path, final String namespace, Collection<String> methods) {
        this(path, Collections2.transform(methods, (Function)new Function<String, SoapScope>(){

            public SoapScope apply(String from) {
                return new SoapScope(namespace, from);
            }
        }));
    }

    public boolean allow(HttpServletRequest request, String user) {
        String pathInfo = ServletUtils.extractPathInfo(request);
        if (this.path.equals(pathInfo)) {
            Document doc = Dom4jUtils.readDocument((ServletRequest)request);
            Element body = doc.getRootElement().element("Body");
            Element methodElement = (Element)body.elements().get(0);
            String name = methodElement.getName();
            String namespace = methodElement.getNamespaceURI();
            for (SoapScope scope : this.soapActions) {
                if (!scope.match(namespace, name)) continue;
                return true;
            }
        }
        return false;
    }

    public Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }

    public static class SoapScope {
        private final String namespace;
        private final String name;

        public SoapScope(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public boolean match(String namespace, String name) {
            return this.namespace.equals(namespace) && this.name.equals(name);
        }
    }
}

