/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.spi.permission.scope;

import com.atlassian.plugin.connect.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.connect.spi.util.ServletUtils;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class JsonRpcApiScopeHelper {
    private final Collection<String> methods;
    private final String path;
    private final Iterable<ApiResourceInfo> apiResourceInfo;

    public JsonRpcApiScopeHelper(final String path, Collection<String> methods) {
        this.path = path;
        this.methods = methods;
        this.apiResourceInfo = Iterables.transform(methods, (Function)new Function<String, ApiResourceInfo>(){

            public ApiResourceInfo apply(String from) {
                return new ApiResourceInfo(path, "POST", from);
            }
        });
    }

    public boolean allow(HttpServletRequest request, String user) {
        String pathInfo = ServletUtils.extractPathInfo(request);
        if (this.path.equals(pathInfo)) {
            String method = this.extractMethod(request);
            if (method == null) {
                return false;
            }
            return this.methods.contains(method);
        }
        String method = pathInfo.replaceAll(this.path.toString() + "/", "");
        return this.methods.contains(method);
    }

    public Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractMethod(HttpServletRequest request) {
        ServletInputStream in = null;
        try {
            in = request.getInputStream();
            InputStreamReader reader = new InputStreamReader((InputStream)in);
            JSONObject json = (JSONObject)JSONValue.parse(reader);
            String string = json.get("method").toString();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

