/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.spi.permission;

import com.atlassian.plugin.connect.spi.permission.Permission;
import com.atlassian.plugin.connect.spi.permission.PermissionInfo;
import com.google.common.base.Preconditions;

public abstract class AbstractPermission
implements Permission {
    private final String key;
    private final PermissionInfo permissionInfo;

    protected AbstractPermission(String key) {
        this(key, EmptyPermissionInfo.INSTANCE);
    }

    protected AbstractPermission(String key, PermissionInfo permissionInfo) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.permissionInfo = (PermissionInfo)Preconditions.checkNotNull((Object)permissionInfo);
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    public final String getName() {
        return this.permissionInfo.getName();
    }

    public final String getDescription() {
        return this.permissionInfo.getDescription();
    }

    @Override
    public final PermissionInfo getPermissionInfo() {
        return this.permissionInfo;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractPermission)) {
            return false;
        }
        AbstractPermission that = (AbstractPermission)o;
        return this.key.equals(that.key);
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    private static enum EmptyPermissionInfo implements PermissionInfo
    {
        INSTANCE;


        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getDescription() {
            return "";
        }
    }
}

