/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.spi.module;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.connect.api.service.http.bigpipe.BigPipeManager;
import com.atlassian.plugin.connect.spi.RemotablePluginAccessorFactory;
import com.atlassian.plugin.connect.spi.http.HttpMethod;
import com.atlassian.plugin.connect.spi.product.ProductAccessor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteCondition
implements Condition {
    private URI url;
    private String pluginKey;
    private String toHideSelector;
    private Iterable<String> contextParams;
    private final ProductAccessor productAccessor;
    private final RemotablePluginAccessorFactory remotablePluginAccessorFactory;
    private final BigPipeManager bigPipeManager;
    private final UserManager userManager;
    private final TemplateRenderer templateRenderer;
    private static final Logger log = LoggerFactory.getLogger(RemoteCondition.class);

    public RemoteCondition(ProductAccessor productAccessor, RemotablePluginAccessorFactory remotablePluginAccessorFactory, BigPipeManager bigPipeManager, UserManager userManager, TemplateRenderer templateRenderer) {
        this.productAccessor = productAccessor;
        this.remotablePluginAccessorFactory = remotablePluginAccessorFactory;
        this.bigPipeManager = bigPipeManager;
        this.userManager = userManager;
        this.templateRenderer = templateRenderer;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.url = URI.create(params.get("url"));
        this.pluginKey = params.get("pluginKey");
        this.toHideSelector = params.get("toHideSelector");
        this.contextParams = Collections.emptyList();
        if (params.get("contextParams") != null) {
            this.contextParams = Arrays.asList(params.get("contextParams").split(","));
        }
        Preconditions.checkNotNull((Object)this.url);
        Preconditions.checkNotNull((Object)this.pluginKey);
        Preconditions.checkNotNull((Object)this.toHideSelector);
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Promise responsePromise = this.remotablePluginAccessorFactory.get(this.pluginKey).executeAsync(HttpMethod.GET, this.url, this.getParameters(context), Collections.<String, String>emptyMap()).fold((Function)new Function<Throwable, String>(){

            public String apply(Throwable t) {
                log.warn("Unable to retrieve remote condition from plugin {}: {}", (Object)RemoteCondition.this.pluginKey, (Object)t);
                return "<script>AJS.log('Unable to retrieve remote condition from plugin '" + RemoteCondition.this.pluginKey + "'');</script>";
            }
        }, (Function)new Function<String, String>(){

            public String apply(String value) {
                try {
                    JSONObject obj = (JSONObject)JSONValue.parseWithException(value);
                    if (((Boolean)obj.get("shouldDisplay")).booleanValue()) {
                        return "<script>AJS.$(\"" + RemoteCondition.this.toHideSelector + "\").removeClass('hidden').parent().removeClass('hidden');</script>";
                    }
                }
                catch (ParseException e) {
                    log.warn("Invalid JSON returned from remote condition: " + value);
                }
                return "";
            }
        });
        this.bigPipeManager.getBigPipe().getHtmlChannel().promiseContent((Promise<String>)responsePromise);
        return true;
    }

    private Map<String, String> getParameters(Map<String, Object> context) {
        HashMap params = Maps.newHashMap();
        for (String contextParam : this.contextParams) {
            params.put(contextParam, this.templateRenderer.renderFragment(this.productAccessor.getLinkContextParams().get(contextParam), context));
        }
        String remoteUsername = this.userManager.getRemoteUsername();
        params.put("user_id", remoteUsername != null ? remoteUsername : "");
        return params;
    }
}

