/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.spi.module;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.profile.ViewProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptor;
import com.atlassian.plugin.connect.spi.PermissionDeniedException;
import com.atlassian.plugin.connect.spi.module.IFrameContext;
import com.atlassian.plugin.connect.spi.module.IFrameRenderer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IFrameViewProfilePanel
implements ViewProfilePanel {
    private static final Logger log = LoggerFactory.getLogger(IFrameViewProfilePanel.class);
    private final IFrameRenderer iFrameRenderer;
    private final IFrameContext iFrameContext;

    public IFrameViewProfilePanel(IFrameRenderer iFrameRenderer, IFrameContext iFrameContext) {
        this.iFrameRenderer = (IFrameRenderer)Preconditions.checkNotNull((Object)iFrameRenderer);
        this.iFrameContext = (IFrameContext)Preconditions.checkNotNull((Object)iFrameContext);
    }

    public void init(ViewProfilePanelModuleDescriptor viewProfilePanelModuleDescriptor) {
    }

    public String getHtml(User user) {
        StringWriter writer = new StringWriter();
        try {
            String remoteUser = user != null ? user.getName() : null;
            writer.write(this.iFrameRenderer.render(this.iFrameContext, remoteUser));
        }
        catch (PermissionDeniedException ex) {
            writer.write("Unauthorized to view this panel");
            log.warn("Unauthorized view of panel");
        }
        catch (IOException e) {
            writer.write("Unable to render panel: " + e.getMessage());
            log.error("Error rendering panel", (Throwable)e);
        }
        return writer.toString();
    }
}

