/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.spi.http.bigpipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingList;
import java.util.List;
import org.slf4j.Logger;

public final class LoggingList<E>
extends ForwardingList<E> {
    private final Logger logger;
    private final String name;
    private final List<E> delegate;

    public LoggingList(Logger logger, String name, List<E> delegate) {
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.delegate = (List)Preconditions.checkNotNull(delegate);
    }

    protected List<E> delegate() {
        return this.delegate;
    }

    public boolean add(E element) {
        this.logger.debug("Adding to {} list: {}", (Object)this.name, element);
        return super.add(element);
    }

    public boolean remove(Object element) {
        this.logger.debug("Removing from {} list: {}", (Object)this.name, element);
        return super.remove(element);
    }

    public void clear() {
        this.logger.debug("Clearing '{}' list.", (Object)this.name);
        super.clear();
    }
}

