/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.spi.http.bigpipe;

import com.atlassian.plugin.connect.api.service.http.bigpipe.Channel;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;

abstract class AbstractChannel
implements Channel {
    private final String id;
    private int retainCount;

    protected AbstractChannel(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public final void retainWhile(Promise promise) {
        this.retain();
        this.registerHandlers(promise);
    }

    private void registerHandlers(Promise promise) {
        Preconditions.checkNotNull((Object)promise);
        promise.then(new FutureCallback(){

            public void onSuccess(Object result) {
                AbstractChannel.this.handleSuccess(result);
            }

            public void onFailure(Throwable t) {
                AbstractChannel.this.release();
            }
        });
    }

    private <A> void handleSuccess(A result) {
        if (result instanceof Promise) {
            this.registerHandlers((Promise)result);
        } else {
            this.release();
        }
    }

    Channel retain() {
        ++this.retainCount;
        return this;
    }

    boolean isRetained() {
        return this.retainCount > 0;
    }

    Channel release() {
        --this.retainCount;
        return this;
    }
}

