/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.webhooks;

import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.plugin.connect.spi.event.product.PluginsUpgradedEvent;
import com.atlassian.plugin.connect.spi.event.product.ServerUpgradedEvent;
import com.atlassian.plugin.connect.spi.event.product.UpgradedEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.webhooks.spi.provider.EventSerializer;
import com.atlassian.webhooks.spi.provider.EventSerializerFactory;
import com.atlassian.webhooks.spi.provider.EventSerializers;
import com.atlassian.webhooks.spi.provider.WebHookProvider;
import com.atlassian.webhooks.spi.provider.WebHookRegistrar;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public final class ServerWebHookProvider
implements WebHookProvider {
    private final ApplicationProperties applicationProperties;
    private final ConsumerService consumerService;

    @Autowired
    public ServerWebHookProvider(ApplicationProperties applicationProperties, ConsumerService consumerService) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.consumerService = (ConsumerService)Preconditions.checkNotNull((Object)consumerService);
    }

    public void provide(WebHookRegistrar registrar) {
        EventSerializerFactory<UpgradedEvent> upgradeFactory = new EventSerializerFactory<UpgradedEvent>(){

            public EventSerializer create(final UpgradedEvent event) {
                return EventSerializers.forMap((Object)event, (Map)new HashMap<String, Object>(){
                    {
                        this.put("key", ServerWebHookProvider.this.consumerService.getConsumer().getKey());
                        this.put("baseUrl", Strings.nullToEmpty((String)ServerWebHookProvider.this.applicationProperties.getBaseUrl()));
                        this.put("oldVersion", event.getOldVersion());
                        this.put("newVersion", event.getNewVersion());
                    }
                });
            }
        };
        registrar.webhook("server_upgraded").whenFired(ServerUpgradedEvent.class).serializedWith((EventSerializerFactory)upgradeFactory);
        registrar.webhook("plugins_upgraded").whenFired(PluginsUpgradedEvent.class).serializedWith((EventSerializerFactory)upgradeFactory);
    }
}

