/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.webhooks;

import com.atlassian.plugin.connect.spi.event.RemotePluginDisabledEvent;
import com.atlassian.plugin.connect.spi.event.RemotePluginEnabledEvent;
import com.atlassian.plugin.connect.spi.event.RemotePluginEvent;
import com.atlassian.plugin.connect.spi.event.RemotePluginInstalledEvent;
import com.atlassian.webhooks.spi.provider.EventMatcher;
import com.atlassian.webhooks.spi.provider.EventSerializer;
import com.atlassian.webhooks.spi.provider.EventSerializerFactory;
import com.atlassian.webhooks.spi.provider.EventSerializers;
import com.atlassian.webhooks.spi.provider.PluginModuleListenerParameters;
import com.atlassian.webhooks.spi.provider.WebHookProvider;
import com.atlassian.webhooks.spi.provider.WebHookRegistrar;

public final class PluginsWebHookProvider
implements WebHookProvider {
    public static final String REMOTE_PLUGIN_INSTALLED = "remote_plugin_installed";
    public static final String REMOTE_PLUGIN_ENABLED = "remote_plugin_enabled";
    public static final String REMOTE_PLUGIN_DISABLED = "remote_plugin_disabled";

    public void provide(WebHookRegistrar registrar) {
        RemotePluginEventSerializerFactory serializerFactory = new RemotePluginEventSerializerFactory();
        RemotePluginEventMatcher eventTypeMatcher = new RemotePluginEventMatcher();
        registrar.webhook(REMOTE_PLUGIN_INSTALLED).whenFired(RemotePluginInstalledEvent.class).matchedBy(eventTypeMatcher).serializedWith(serializerFactory);
        registrar.webhook(REMOTE_PLUGIN_ENABLED).whenFired(RemotePluginEnabledEvent.class).matchedBy(eventTypeMatcher).serializedWith(serializerFactory);
        registrar.webhook(REMOTE_PLUGIN_DISABLED).whenFired(RemotePluginDisabledEvent.class).matchedBy(eventTypeMatcher).serializedWith(serializerFactory);
    }

    private static final class RemotePluginEventSerializerFactory<E extends RemotePluginEvent>
    implements EventSerializerFactory<E> {
        private RemotePluginEventSerializerFactory() {
        }

        public EventSerializer create(E event) {
            return EventSerializers.forMap(event, ((RemotePluginEvent)event).toMap());
        }
    }

    private static final class RemotePluginEventMatcher<E extends RemotePluginEvent>
    implements EventMatcher<E> {
        private RemotePluginEventMatcher() {
        }

        public boolean matches(E event, Object consumerParams) {
            return consumerParams instanceof PluginModuleListenerParameters && ((PluginModuleListenerParameters)consumerParams).getPluginKey().equals(((RemotePluginEvent)event).getPluginKey());
        }
    }
}

