/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.util.zip;

import com.atlassian.plugin.connect.plugin.util.zip.ZipHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.io.XMLWriter;

public class ZipBuilder {
    public static final String KEY_SEPARATOR = "----remotableplugins-";
    private final ZipOutputStream zout;

    public ZipBuilder(ZipOutputStream zout) {
        this.zout = zout;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File buildZip(String identifier, ZipHandler handler) {
        ZipOutputStream zout = null;
        File tmpFile = null;
        try {
            tmpFile = ZipBuilder.createExtractableTempFile(identifier, ".jar");
            zout = new ZipOutputStream(new FileOutputStream(tmpFile));
            ZipBuilder builder = new ZipBuilder(zout);
            handler.build(builder);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(e);
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zout);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)zout);
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String path, InputStream contents) throws IOException {
        try {
            ZipEntry entry = new ZipEntry(path);
            this.zout.putNextEntry(entry);
            IOUtils.copy((InputStream)contents, (OutputStream)this.zout);
        }
        finally {
            IOUtils.closeQuietly((InputStream)contents);
        }
    }

    public void addFile(String path, String contents) throws IOException {
        ZipEntry entry = new ZipEntry(path);
        this.zout.putNextEntry(entry);
        IOUtils.copy((Reader)new StringReader(contents), (OutputStream)this.zout);
    }

    public static File createExtractableTempFile(String key, String suffix) throws IOException {
        return File.createTempFile(key + KEY_SEPARATOR, suffix);
    }

    public void addFile(String path, Document document) throws IOException {
        StringWriter out = new StringWriter();
        new XMLWriter((Writer)out).write(document);
        this.addFile(path, out.toString());
    }
}

