/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.util.http;

import com.atlassian.fugue.Option;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.plugin.connect.plugin.license.LicenseRetriever;
import com.atlassian.plugin.connect.plugin.util.LocaleHelper;
import com.atlassian.plugin.connect.plugin.util.MapFunctions;
import com.atlassian.plugin.connect.plugin.util.http.ContentRetrievalErrors;
import com.atlassian.plugin.connect.plugin.util.http.ContentRetrievalException;
import com.atlassian.plugin.connect.plugin.util.http.HttpContentRetriever;
import com.atlassian.plugin.connect.spi.http.AuthorizationGenerator;
import com.atlassian.plugin.connect.spi.http.HttpMethod;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingHttpContentRetriever
implements HttpContentRetriever {
    private static final Logger log = LoggerFactory.getLogger(CachingHttpContentRetriever.class);
    private static final Set<HttpMethod> METHODS_WITH_BODY = Sets.immutableEnumSet((Enum)HttpMethod.POST, (Enum[])new HttpMethod[]{HttpMethod.PUT});
    private static final Set<HttpMethod> METHODS_WITH_QUERY_PARAMS = Sets.immutableEnumSet((Enum)HttpMethod.GET, (Enum[])new HttpMethod[0]);
    private static final Map<HttpMethod, Request.Method> METHOD_MAPPING = ImmutableMap.of((Object)((Object)HttpMethod.GET), (Object)Request.Method.GET, (Object)((Object)HttpMethod.POST), (Object)Request.Method.POST, (Object)((Object)HttpMethod.PUT), (Object)Request.Method.PUT);
    private final HttpClient httpClient;
    private final LicenseRetriever licenseRetriever;
    private final LocaleHelper localeHelper;

    public CachingHttpContentRetriever(LicenseRetriever licenseRetriever, LocaleHelper localeHelper, HttpClientFactory httpClientFactory, PluginRetrievalService pluginRetrievalService) {
        this(licenseRetriever, localeHelper, httpClientFactory, CachingHttpContentRetriever.getHttpClientOptions((PluginRetrievalService)Preconditions.checkNotNull((Object)pluginRetrievalService, (Object)"pluginRetrievalService")));
    }

    CachingHttpContentRetriever(LicenseRetriever licenseRetriever, LocaleHelper localeHelper, HttpClientFactory httpClientFactory, HttpClientOptions httpClientOptions) {
        this(licenseRetriever, localeHelper, ((HttpClientFactory)Preconditions.checkNotNull((Object)httpClientFactory, (Object)"httpClientFactory")).create((HttpClientOptions)Preconditions.checkNotNull((Object)httpClientOptions, (Object)"httpClientOptions")));
    }

    CachingHttpContentRetriever(LicenseRetriever licenseRetriever, LocaleHelper localeHelper, HttpClient httpClient) {
        this.licenseRetriever = (LicenseRetriever)Preconditions.checkNotNull((Object)licenseRetriever);
        this.localeHelper = (LocaleHelper)Preconditions.checkNotNull((Object)localeHelper);
        this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient);
    }

    @Override
    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpClient.flushCacheByUriPattern(urlPattern);
    }

    @Override
    public Promise<String> async(AuthorizationGenerator authorizationGenerator, HttpMethod method, URI url, Map<String, String> parameters, Map<String, String> headers, String pluginKey) {
        Preconditions.checkState((boolean)METHOD_MAPPING.keySet().contains((Object)method), (String)"The only valid methods are: %s", (Object[])new Object[]{METHOD_MAPPING.keySet()});
        log.info("{}ing content from '{}'", (Object)method, (Object)url);
        Map<String, String> allParameters = this.getAllParameters(parameters, pluginKey);
        Request request = this.httpClient.newRequest(this.getFullUrl(method, url, allParameters)).setHeaders(this.getAllHeaders(headers, this.getAuthHeaderValue(authorizationGenerator, method, url, allParameters))).setAttributes(this.getAttributes(pluginKey));
        if (Iterables.contains(METHODS_WITH_BODY, (Object)((Object)method))) {
            request.setContentType("application/x-www-form-urlencoded");
            request.setEntity(UriBuilder.joinParameters(this.transformParameters(allParameters)));
        }
        return request.execute(METHOD_MAPPING.get((Object)method)).transform().ok((Function)new OkFunction(url)).forbidden((Function)new ForbiddenFunction(url)).others((Function)new OthersFunction(url)).fail((Function)new FailFunction(url)).toPromise();
    }

    private String getFullUrl(HttpMethod method, URI url, Map<String, String> allParameters) {
        UriBuilder uriBuilder = new UriBuilder(Uri.fromJavaUri(url));
        if (Iterables.contains(METHODS_WITH_QUERY_PARAMS, (Object)((Object)method))) {
            uriBuilder.addQueryParameters(allParameters);
        }
        return uriBuilder.toString();
    }

    private Map<String, String> getAttributes(String pluginKey) {
        HashMap properties = Maps.newHashMap();
        properties.put("purpose", "content-retrieval");
        properties.put("moduleKey", pluginKey);
        return properties;
    }

    private Map<String, String> getAllHeaders(Map<String, String> headers, Option<String> authHeader) {
        ImmutableMap.Builder allHeaders = ImmutableMap.builder().putAll(headers);
        if (authHeader.isDefined()) {
            allHeaders.put((Object)"Authorization", authHeader.get());
        }
        return allHeaders.build();
    }

    private Option<String> getAuthHeaderValue(AuthorizationGenerator authorizationGenerator, HttpMethod method, URI url, Map<String, String> allParameters) {
        return authorizationGenerator.generate(method, url, this.transformParameters(allParameters));
    }

    private Map<String, List<String>> transformParameters(Map<String, String> allParameters) {
        return Maps.transformValues(allParameters, MapFunctions.STRING_TO_LIST);
    }

    private Map<String, String> getAllParameters(Map<String, String> parameters, String pluginKey) {
        return ImmutableMap.builder().putAll(parameters).put((Object)"lic", (Object)this.getLicenseStatusAsString(pluginKey)).put((Object)"loc", (Object)this.getLocale()).build();
    }

    private String getLicenseStatusAsString(String pluginKey) {
        return this.licenseRetriever.getLicenseStatus(pluginKey).value();
    }

    private String getLocale() {
        return this.localeHelper.getLocaleTag();
    }

    @Override
    public Promise<String> getAsync(AuthorizationGenerator authorizationGenerator, String remoteUsername, URI url, Map<String, String> parameters, Map<String, String> headers, String pluginKey) {
        return this.async(authorizationGenerator, HttpMethod.GET, url, parameters, headers, pluginKey);
    }

    private static HttpClientOptions getHttpClientOptions(PluginRetrievalService pluginRetrievalService) {
        HttpClientOptions options = new HttpClientOptions();
        options.setIoSelectInterval(100, TimeUnit.MILLISECONDS);
        options.setThreadPrefix("http-content-retriever");
        options.setMaxConnectionsPerHost(100);
        options.setUserAgent("Atlassian-Connect/" + pluginRetrievalService.getPlugin().getPluginInformation().getVersion());
        options.setConnectionTimeout(3, TimeUnit.SECONDS);
        options.setSocketTimeout(15, TimeUnit.SECONDS);
        options.setRequestTimeout(20, TimeUnit.SECONDS);
        return options;
    }

    private static final class FailFunction
    implements Function<Throwable, String> {
        private final URI url;

        public FailFunction(URI url) {
            this.url = url;
        }

        public String apply(Throwable input) {
            if (!(input instanceof ContentRetrievalException)) {
                log.debug("Return failed: {}", (Object)this.url);
                log.debug(input.getMessage(), input);
                throw new ContentRetrievalException(input);
            }
            throw (ContentRetrievalException)input;
        }
    }

    private static final class ForbiddenFunction
    implements Function<Response, String> {
        private final URI url;

        public ForbiddenFunction(URI url) {
            this.url = url;
        }

        public String apply(Response input) {
            log.debug("Returned forbidden: {}", (Object)this.url);
            throw new ContentRetrievalException("Operation not authorized!");
        }
    }

    private static class OthersFunction
    implements Function<Response, String> {
        private final URI url;

        public OthersFunction(URI url) {
            this.url = url;
        }

        public String apply(Response input) {
            log.debug("Returned others: {}", (Object)this.url);
            if ("application/json".equalsIgnoreCase(input.getContentType())) {
                throw new ContentRetrievalException(ContentRetrievalErrors.fromJson(input.getEntity()));
            }
            log.debug("An unknown error occurred retrieving HTTP content. Status is {}, body content is:\n{}\n", (Object)input.getStatusCode(), (Object)input.getEntity());
            throw new ContentRetrievalException("An unknown error occurred!");
        }
    }

    private static class OkFunction
    implements Function<Response, String> {
        private final URI url;

        public OkFunction(URI url) {
            this.url = url;
        }

        public String apply(Response input) {
            log.debug("Returned ok content from: {}", (Object)this.url);
            return input.getEntity();
        }
    }
}

