/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class BundleUtil {
    private static final Bundle NOT_FOUND_BUNDLE = null;

    private BundleUtil() {
    }

    public static Bundle findBundleForPlugin(BundleContext bundleContext, String pluginKey) {
        return BundleUtil.findBundleForPlugin(Lists.newArrayList((Object[])bundleContext.getBundles()), pluginKey);
    }

    private static Bundle findBundleForPlugin(Iterable<Bundle> bundles, final String pluginKey) {
        return (Bundle)Iterables.find(bundles, (Predicate)new Predicate<Bundle>(){

            public boolean apply(Bundle b) {
                return pluginKey.equals(b.getHeaders().get("Atlassian-Plugin-Key"));
            }
        }, (Object)NOT_FOUND_BUNDLE);
    }

    public static Bundle findBundleWithName(BundleContext bundleContext, String symbolicName) {
        return BundleUtil.findBundleWithName(Lists.newArrayList((Object[])bundleContext.getBundles()), symbolicName);
    }

    private static Bundle findBundleWithName(Iterable<Bundle> bundles, final String symbolicName) {
        return (Bundle)Iterables.find(bundles, (Predicate)new Predicate<Bundle>(){

            public boolean apply(Bundle b) {
                return b.getSymbolicName().equals(symbolicName);
            }
        }, (Object)NOT_FOUND_BUNDLE);
    }

    public static Iterable<String> toBundleNames(Bundle[] bundles) {
        return Iterables.transform((Iterable)Lists.newArrayList((Object[])bundles), (Function)new Function<Bundle, String>(){

            public String apply(Bundle b) {
                return b.getSymbolicName();
            }
        });
    }
}

