/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.service;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.connect.spi.ConnectAddOnIdentifierService;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import java.io.File;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.osgi.framework.Bundle;

public class DefaultConnectAddOnIdentifierService
implements ConnectAddOnIdentifierService {
    private final PluginAccessor pluginAccessor;

    public DefaultConnectAddOnIdentifierService(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public boolean isConnectAddOn(Bundle bundle) {
        try {
            return bundle.getHeaders() != null && bundle.getHeaders().get("Remote-Plugin") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isConnectAddOn(Plugin plugin) {
        try {
            Manifest mf = new Manifest(plugin.getResourceAsStream("/META-INF/MANIFEST.MF"));
            return mf.getMainAttributes().containsKey(new Attributes.Name("Remote-Plugin"));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isConnectAddOn(String pluginKey) {
        return this.isConnectAddOn(this.pluginAccessor.getPlugin(pluginKey));
    }

    @Override
    public boolean isConnectAddOn(Document pluginDescriptor) {
        try {
            Element root = pluginDescriptor.getRootElement();
            return null != root.element("remote-plugin-container");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isConnectAddOn(File descriptorFile) {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(descriptorFile);
            return this.isConnectAddOn(doc);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getInstallerUser(Bundle bundle) {
        String header = (String)bundle.getHeaders().get("Remote-Plugin");
        if (header != null) {
            return (String)((Map)OsgiHeaderUtil.parseHeader((String)header).get("installer")).get("user");
        }
        return null;
    }

    @Override
    public String getRegistrationUrl(Bundle bundle) {
        String header = (String)bundle.getHeaders().get("Remote-Plugin");
        if (header != null) {
            return (String)((Map)OsgiHeaderUtil.parseHeader((String)header).get("installer")).get("registration-url");
        }
        return null;
    }
}

