/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.rest.email;

import com.atlassian.plugin.connect.plugin.module.permission.ApiScopingFilter;
import com.atlassian.plugin.connect.plugin.rest.email.RemoteEmail;
import com.atlassian.plugin.connect.plugin.service.LocalEmailSender;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="email")
public class EmailSenderResource {
    private final LocalEmailSender localEmailSender;

    public EmailSenderResource(LocalEmailSender localEmailSender) {
        this.localEmailSender = localEmailSender;
    }

    @POST
    public Response sendEmail(@Context HttpServletRequest request, RemoteEmail remoteEmail) {
        this.localEmailSender.send(ApiScopingFilter.extractClientKey(request), remoteEmail.getTo(), remoteEmail.toEmail(), remoteEmail.getBodyAsHtml(), remoteEmail.getBodyAsText());
        return Response.noContent().build();
    }

    @GET
    @Path(value="/flush")
    public Response flush(@Context HttpServletRequest request) {
        this.localEmailSender.flush(ApiScopingFilter.extractClientKey(request));
        return Response.noContent().build();
    }
}

