/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.rest;

import com.atlassian.plugin.connect.plugin.descriptor.DescriptorValidator;
import com.atlassian.plugin.connect.plugin.settings.SettingsManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.bouncycastle.openssl.PEMWriter;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/installer")
public class InstallerResource {
    public static final String INSTALLER_RESOURCE_PATH = "/installer";
    public static final String ATLASSIAN_PLUGIN_REMOTABLE_SCHEMA_PATH = "/schema/atlassian-plugin-remotable";
    public static final String ATLASSIAN_PLUGIN_SCHEMA_PATH = "/schema/atlassian-plugin";
    private static final Logger log = LoggerFactory.getLogger(InstallerResource.class);
    private final UserManager userManager;
    private final DescriptorValidator descriptorValidator;
    private final SettingsManager settingsManager;

    public InstallerResource(UserManager userManager, DescriptorValidator descriptorValidator, SettingsManager settingsManager) {
        this.userManager = userManager;
        this.descriptorValidator = descriptorValidator;
        this.settingsManager = settingsManager;
    }

    @PUT
    @Path(value="/allow-dogfooding")
    public Response allowDogfooding() {
        if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.settingsManager.setAllowDogfooding(true);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/allow-dogfooding")
    public Response disallowDogfooding() {
        if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.settingsManager.setAllowDogfooding(false);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/allow-dogfooding")
    public Response doesAllowDogfooding() {
        if (this.settingsManager.isAllowDogfooding()) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/schema/atlassian-plugin-remotable")
    @Produces(value={"text/xml"})
    @AnonymousAllowed
    public Response getRemotePluginSchema() {
        return Response.ok().entity((Object)this.descriptorValidator.getPluginSchema()).build();
    }

    @POST
    @Path(value="/keygen")
    @Produces(value={"application/json"})
    public Response generateKeys() throws NoSuchAlgorithmException, IOException, JSONException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = gen.generateKeyPair();
        StringWriter publicKeyWriter = new StringWriter();
        PEMWriter pubWriter = new PEMWriter((Writer)publicKeyWriter);
        pubWriter.writeObject((Object)pair.getPublic());
        pubWriter.close();
        StringWriter privateKeyWriter = new StringWriter();
        PEMWriter privWriter = new PEMWriter((Writer)privateKeyWriter);
        privWriter.writeObject((Object)pair.getPrivate());
        privWriter.close();
        return Response.ok((Object)new JSONObject().put("publicKey", (Object)publicKeyWriter.toString()).put("privateKey", (Object)privateKeyWriter.toString()).toString(2)).build();
    }
}

