/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.product.confluence.webhook;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.userstatus.UserStatus;
import com.atlassian.plugin.connect.plugin.product.EventMapper;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ConfluenceEventMapper
implements EventMapper<ConfluenceEvent> {
    private final UserManager userManager;
    private final SettingsManager confluenceSettingsManager;

    public ConfluenceEventMapper(UserManager userManager, SettingsManager confluenceSettingsManager) {
        this.userManager = userManager;
        this.confluenceSettingsManager = confluenceSettingsManager;
    }

    @Override
    public Map<String, Object> toMap(ConfluenceEvent event) {
        String username = this.userManager.getRemoteUsername();
        return ImmutableMap.of((Object)"timestamp", (Object)event.getTimestamp(), (Object)"user", (Object)(StringUtils.isBlank((String)username) ? "" : username));
    }

    @Override
    public boolean handles(ConfluenceEvent e) {
        return true;
    }

    protected Map<String, Object> labelableToMap(Labelable labelable) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"labels", (Object)Lists.transform((List)labelable.getLabels(), (Function)new Function<Label, Map<String, Object>>(){

            public Map<String, Object> apply(Label label) {
                return ConfluenceEventMapper.this.labelToMap(label, true);
            }
        }));
        if (labelable instanceof ContentEntityObject) {
            builder.putAll(this.contentEntityObjectToMap((ContentEntityObject)labelable));
        } else if (labelable instanceof Attachment) {
            builder.putAll(this.attachmentToMap((Attachment)labelable));
        }
        return builder.build();
    }

    protected Map<String, Object> labelToMap(Label label) {
        return this.labelToMap(label, false);
    }

    protected Map<String, Object> labelToMap(Label label, boolean nameOnly) {
        if (nameOnly) {
            return ImmutableMap.of((Object)"name", (Object)label.getName());
        }
        return ImmutableMap.of((Object)"name", (Object)label.getName(), (Object)"owner", (Object)(StringUtils.isBlank((String)label.getOwner()) ? "" : label.getOwner()), (Object)"title", (Object)label.getDisplayTitle(), (Object)"self", (Object)this.getFullUrl(label.getUrlPath()));
    }

    protected Map<String, Object> userStatusToMap(UserStatus status) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)status.getId());
        builder.put((Object)"content", (Object)status.getTitle());
        builder.put((Object)"self", (Object)this.getFullUrl(status.getUrlPath()));
        builder.put((Object)"creatorName", (Object)status.getCreatorName());
        builder.put((Object)"creationDate", (Object)status.getCreationDate().getTime());
        builder.put((Object)"isCurrent", (Object)status.getContentStatus().equals("current"));
        return builder.build();
    }

    protected Map<String, Object> contentEntityObjectToMap(ContentEntityObject ceo, boolean idOnly) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)ceo.getId());
        if (!idOnly) {
            Space space;
            if (!StringUtils.isBlank((String)ceo.getTitle())) {
                builder.put((Object)"title", (Object)ceo.getTitle());
            }
            builder.put((Object)"creatorName", (Object)(StringUtils.isBlank((String)ceo.getCreatorName()) ? "" : ceo.getCreatorName()));
            builder.put((Object)"lastModifierName", (Object)(StringUtils.isBlank((String)ceo.getLastModifierName()) ? "" : ceo.getLastModifierName()));
            builder.put((Object)"creationDate", ceo.getCreationDate() != null ? Long.valueOf(ceo.getCreationDate().getTime()) : "");
            builder.put((Object)"modificationDate", ceo.getLastModificationDate() != null ? Long.valueOf(ceo.getLastModificationDate().getTime()) : "");
            builder.put((Object)"version", (Object)ceo.getVersion());
            builder.put((Object)"self", (Object)this.getFullUrl(ceo.getUrlPath()));
            if (ceo instanceof Spaced && (space = ((Spaced)ceo).getSpace()) != null) {
                builder.put((Object)"spaceKey", (Object)space.getKey());
            }
        }
        return builder.build();
    }

    protected String getFullUrl(String relativeUrl) {
        return this.confluenceSettingsManager.getGlobalSettings().getBaseUrl() + relativeUrl;
    }

    protected Map<String, Object> attachmentToMap(Attachment attachment) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"fileName", (Object)attachment.getFileName());
        builder.put((Object)"version", (Object)attachment.getVersion());
        builder.put((Object)"comment", (Object)(StringUtils.isBlank((String)attachment.getComment()) ? "" : attachment.getComment()));
        builder.put((Object)"fileSize", (Object)attachment.getFileSize());
        builder.put((Object)"id", (Object)attachment.getId());
        builder.put((Object)"creatorName", (Object)(StringUtils.isBlank((String)attachment.getCreatorName()) ? "" : attachment.getCreatorName()));
        builder.put((Object)"creationDate", (Object)attachment.getCreationDate().getTime());
        builder.put((Object)"lastModifierName", (Object)(StringUtils.isBlank((String)attachment.getLastModifierName()) ? "" : attachment.getLastModifierName()));
        builder.put((Object)"modificationDate", (Object)attachment.getLastModificationDate().getTime());
        builder.put((Object)"self", (Object)this.getFullUrl(attachment.getDownloadPath()));
        return builder.build();
    }

    protected Map<String, Object> spaceToMap(Space space) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"key", (Object)space.getKey());
        builder.put((Object)"title", (Object)space.getDisplayTitle());
        if (space.getDescription() != null) {
            builder.put((Object)"description", (Object)space.getDescription().getBodyAsString());
        }
        builder.put((Object)"isPersonalSpace", (Object)space.isPersonal());
        builder.put((Object)"self", (Object)this.getFullUrl(space.getUrlPath()));
        Page homePage = space.getHomePage();
        if (homePage != null) {
            builder.put((Object)"homePage", this.contentEntityObjectToMap((ContentEntityObject)homePage, true));
        }
        builder.put((Object)"creatorName", (Object)(StringUtils.isBlank((String)space.getCreatorName()) ? "" : space.getCreatorName()));
        builder.put((Object)"creationDate", (Object)space.getCreationDate().getTime());
        builder.put((Object)"lastModifierName", (Object)(StringUtils.isBlank((String)space.getLastModifierName()) ? "" : space.getLastModifierName()));
        builder.put((Object)"modificationDate", (Object)space.getLastModificationDate().getTime());
        return builder.build();
    }

    protected Map<String, Object> contentEntityObjectToMap(ContentEntityObject ceo) {
        return this.contentEntityObjectToMap(ceo, false);
    }

    protected Map<String, Object> commentToMap(Comment comment) {
        return this.commentToMap(comment, false);
    }

    protected Map<String, Object> commentToMap(Comment comment, boolean idOnly) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.contentEntityObjectToMap((ContentEntityObject)comment, idOnly));
        if (!idOnly) {
            builder.put((Object)"parent", this.contentEntityObjectToMap(comment.getOwner()));
            if (comment.getParent() != null) {
                builder.put((Object)"inReplyTo", this.commentToMap(comment.getParent(), true));
            }
        }
        return builder.build();
    }
}

