/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.product;

import com.atlassian.plugin.connect.api.service.http.bigpipe.BigPipeManager;
import com.atlassian.plugin.connect.api.service.http.bigpipe.ConsumableBigPipe;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BigPipeFooter
implements WebPanel {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FOOTER = "<script>(function(){_AP.require(['condition/remote'], function(remoteCondition) { remoteCondition.hide(); });_AP.require(['bigpipe/bigpipe'], function(bigPipe) { bigPipe.start({requestId:'%s',ready: %s}); });}())</script>\n";
    private final BigPipeManager bigPipeManager;

    public BigPipeFooter(BigPipeManager bigPipeManager) {
        this.bigPipeManager = (BigPipeManager)Preconditions.checkNotNull((Object)bigPipeManager);
    }

    public String getHtml(Map<String, Object> context) {
        StringWriter writer = new StringWriter();
        try {
            this.writeHtml(writer, context);
            String string = ((Object)writer).toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Should never ever happen, we're using a StringWriter!", e);
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
    }

    public void writeHtml(Writer writer, Map<String, Object> context) throws IOException {
        writer.write(this.getHtml());
    }

    private String getHtml() {
        return (String)this.bigPipeManager.getConsumableBigPipe().fold((Supplier)new Supplier<String>(){

            public String get() {
                BigPipeFooter.this.logger.debug("Did NOT find ANY big pipe content, no footer required.");
                return "";
            }
        }, (Function)new Function<ConsumableBigPipe, String>(){

            public String apply(ConsumableBigPipe input) {
                String requestId = input.getRequestId();
                String footer = String.format(BigPipeFooter.FOOTER, requestId, input.consumeContent());
                BigPipeFooter.this.logger.debug("Found big pipe content for request {}, generated the following footer: {}", (Object)requestId, (Object)footer);
                return footer;
            }
        });
    }
}

