/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.oldscopes.jira;

import com.atlassian.plugin.connect.spi.permission.AbstractPermission;
import com.atlassian.plugin.connect.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.connect.spi.permission.scope.ApiScope;
import com.atlassian.plugin.connect.spi.permission.scope.JsonRpcApiScopeHelper;
import com.atlassian.plugin.connect.spi.permission.scope.RestApiScopeHelper;
import com.atlassian.plugin.connect.spi.permission.scope.RpcEncodedSoapApiScopeHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

abstract class JiraScope
extends AbstractPermission
implements ApiScope {
    private final RpcEncodedSoapApiScopeHelper soapScopeHelper;
    private final JsonRpcApiScopeHelper jsonRpcScopeHelper;
    private final Iterable<ApiResourceInfo> apiResourceInfo;
    private final RestApiScopeHelper restApiScopeHelper;

    protected JiraScope(String key, Collection<String> methods, Collection<RestApiScopeHelper.RestScope> resources) {
        super(key);
        this.soapScopeHelper = new RpcEncodedSoapApiScopeHelper("/rpc/soap/jirasoapservice-v2", "http://soap.rpc.jira.atlassian.com", (Collection)Preconditions.checkNotNull(methods));
        this.jsonRpcScopeHelper = new JsonRpcApiScopeHelper("/rpc/json-rpc/jirasoapservice-v2", methods);
        this.restApiScopeHelper = new RestApiScopeHelper((Iterable)Preconditions.checkNotNull(resources));
        this.apiResourceInfo = Iterables.concat(this.soapScopeHelper.getApiResourceInfos(), this.jsonRpcScopeHelper.getApiResourceInfos(), this.restApiScopeHelper.getApiResourceInfos());
    }

    @Override
    public final boolean allow(HttpServletRequest request, String user) {
        return this.soapScopeHelper.allow(request, user) || this.jsonRpcScopeHelper.allow(request, user) || this.restApiScopeHelper.allow(request, user);
    }

    @Override
    public final Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }
}

