/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.module.webpanel.extractor.jira;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.connect.plugin.module.webpanel.extractor.WebPanelParameterExtractor;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;

public class ProfileUserWebPanelParameterExtractor
implements WebPanelParameterExtractor {
    public static final String PROFILE_USER_CONTEXT_KEY = "profileUser";
    private final UserUtil userUtil;

    public ProfileUserWebPanelParameterExtractor(UserUtil userUtil) {
        this.userUtil = userUtil;
    }

    @Override
    public Map<String, Object> extract(Map<String, Object> context) {
        if (context.containsKey(PROFILE_USER_CONTEXT_KEY)) {
            Principal principal = (Principal)context.get(PROFILE_USER_CONTEXT_KEY);
            ApplicationUser profileUser = this.userUtil.getUserByName(principal.getName());
            return ImmutableMap.of((Object)PROFILE_USER_CONTEXT_KEY, (Object)ImmutableMap.of((Object)"name", (Object)profileUser.getName(), (Object)"key", (Object)profileUser.getKey()));
        }
        return Collections.emptyMap();
    }
}

