/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.module.webfragment;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UrlVariableSubstitutor {
    private static final Logger log = LoggerFactory.getLogger(UrlVariableSubstitutor.class);
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([^}]*)}");

    public String replace(String source, Map<String, Object> context) {
        Matcher m = PATTERN.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String term = m.group(1);
            String value = this.fromContext(term, context);
            m.appendReplacement(sb, this.encodeQuery(value));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String encodeQuery(String value) {
        try {
            return URIUtil.encodeWithinQuery((String)value);
        }
        catch (URIException ex) {
            log.error("Error encoding value '" + value + "' to querystring", (Throwable)ex);
            return "";
        }
    }

    private String fromContext(String term, Map<String, Object> context) {
        List<String> terms = Arrays.asList(term.split("\\."));
        Object value = this.fromContext(terms, context);
        if (null == value) {
            return "";
        }
        if (value instanceof Number || value instanceof String || value instanceof Boolean) {
            return value.toString();
        }
        return "";
    }

    private Object fromContext(Iterable<String> terms, Map<String, Object> context) {
        Object current = context;
        for (String key : terms) {
            if (null == current) {
                return null;
            }
            if (!(current instanceof Map)) continue;
            current = current.get(key);
        }
        return current;
    }
}

