/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.module.jira.workflow;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.atlassian.plugin.connect.plugin.module.jira.workflow.RemoteWorkflowPostFunctionEvent;
import com.atlassian.plugin.connect.plugin.product.jira.JiraRestBeanMarshaler;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class RemoteWorkflowPostFunctionProvider
extends AbstractJiraFunctionProvider {
    private final EventPublisher eventPublisher;
    private final JiraRestBeanMarshaler beanMarshaler;
    private final String pluginKey;
    private final String moduleKey;

    public RemoteWorkflowPostFunctionProvider(EventPublisher eventPublisher, JiraRestBeanMarshaler jiraRestBeanMarshaler, String pluginKey, String moduleKey) {
        this.eventPublisher = eventPublisher;
        this.beanMarshaler = jiraRestBeanMarshaler;
        this.pluginKey = pluginKey;
        this.moduleKey = moduleKey;
    }

    public void execute(Map transientVars, Map args, PropertySet propertySet) throws WorkflowException {
        JSONObject postFunctionJSON = this.postFunctionJSON(transientVars, args);
        this.eventPublisher.publish((Object)new RemoteWorkflowPostFunctionEvent(this.pluginKey, this.moduleKey, postFunctionJSON));
    }

    protected JSONObject postFunctionJSON(Map<?, ?> transientVars, Map args) {
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        Integer actionId = (Integer)transientVars.get("actionId");
        MutableIssue issue = this.getIssue(transientVars);
        WorkflowDescriptor workflowDescriptor = (WorkflowDescriptor)transientVars.get("descriptor");
        ActionDescriptor actionDescriptor = workflowDescriptor.getAction(actionId.intValue());
        Step createdStep = (Step)transientVars.get("createdStep");
        WorkflowStore workflowStore = (WorkflowStore)transientVars.get("store");
        ImmutableMap.Builder transitionBuilder = ImmutableMap.builder();
        transitionBuilder.put((Object)"workflowId", (Object)entry.getId()).put((Object)"workflowName", (Object)entry.getWorkflowName()).put((Object)"transitionId", (Object)actionId).put((Object)"transitionName", (Object)actionDescriptor.getName()).put((Object)"from_status", (Object)this.findPreviousStatus(createdStep, entry, workflowStore, workflowDescriptor)).put((Object)"to_status", (Object)createdStep.getStatus());
        JSONObject transitionJSON = new JSONObject((Map)transitionBuilder.build());
        JSONObject issueJSON = this.beanMarshaler.getRemoteIssue((Issue)issue);
        JSONObject configuration = new JSONObject((Map)ImmutableMap.of((Object)"value", args.get("remoteWorkflowPostFunctionConfiguration")));
        return new JSONObject((Map)ImmutableMap.of((Object)"issue", (Object)issueJSON, (Object)"transition", (Object)transitionJSON, (Object)"configuration", (Object)configuration));
    }

    private String findPreviousStatus(Step currentStep, WorkflowEntry entry, WorkflowStore workflowStore, WorkflowDescriptor workflowDescriptor) {
        if (currentStep.getPreviousStepIds().length == 0) {
            return "";
        }
        final long previousStepId = currentStep.getPreviousStepIds()[0];
        try {
            List historySteps = workflowStore.findHistorySteps(entry.getId());
            Step previousStep = (Step)Iterables.find((Iterable)historySteps, (Predicate)new Predicate<Step>(){

                public boolean apply(Step step) {
                    return step.getId() == previousStepId;
                }
            }, null);
            return workflowDescriptor.getStep(previousStep.getStepId()).getName();
        }
        catch (StoreException e) {
            return "";
        }
    }
}

