/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.module.jira.searchrequestview;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.SingleIssueWriter;
import com.atlassian.jira.issue.views.util.SearchRequestViewBodyWriterUtil;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.plugin.issueview.AbstractIssueView;
import com.atlassian.jira.plugin.searchrequestview.RequestHeaders;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestViewModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.connect.plugin.module.util.redirect.RedirectServlet;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RemoteSearchRequestView
implements SearchRequestView {
    private final ApplicationProperties applicationProperties;
    private final SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil;
    private final TemplateRenderer templateRenderer;
    private final String appKey;
    private final URI path;
    private final String name;

    public RemoteSearchRequestView(ApplicationProperties applicationProperties, SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil, TemplateRenderer templateRenderer, String appKey, URI path, String name) {
        this.applicationProperties = applicationProperties;
        this.searchRequestViewBodyWriterUtil = searchRequestViewBodyWriterUtil;
        this.templateRenderer = templateRenderer;
        this.appKey = appKey;
        this.path = path;
        this.name = name;
    }

    public void init(SearchRequestViewModuleDescriptor moduleDescriptor) {
    }

    public void writeHeaders(SearchRequest searchRequest, RequestHeaders requestHeaders, SearchRequestParams searchRequestParams) {
    }

    public void writeSearchResults(SearchRequest searchRequest, SearchRequestParams searchRequestParams, Writer writer) {
        JiraAuthenticationContext jiraAuthenticationContext = ComponentManager.getInstance().getJiraAuthenticationContext();
        HashMap queryParams = Maps.newHashMap();
        String baseUrl = this.applicationProperties.getBaseUrl();
        queryParams.put("link", SearchRequestViewUtils.getLink((SearchRequest)searchRequest, (String)baseUrl, (User)jiraAuthenticationContext.getLoggedInUser()));
        int startIssue = searchRequestParams.getPagerFilter().getStart();
        queryParams.put("startIssue", String.valueOf(startIssue));
        long totalIssues = this.getSearchCount(searchRequest, searchRequestParams);
        queryParams.put("totalIssues", String.valueOf(totalIssues));
        long tempMax = searchRequestParams.getPagerFilter().getMax() < 0 ? 0L : (long)searchRequestParams.getPagerFilter().getMax();
        queryParams.put("endIssue", String.valueOf(Math.min((long)startIssue + tempMax, totalIssues)));
        String issueKeysValue = this.getIssueKeysList(searchRequest, searchRequestParams);
        queryParams.put("issues", issueKeysValue);
        String redirectUrl = RedirectServlet.getOAuthRedirectUrl(baseUrl, this.appKey, this.path, queryParams);
        try {
            this.templateRenderer.render("velocity/view-search-request-redirect.vm", (Map)ImmutableMap.of((Object)"redirectUrl", (Object)redirectUrl, (Object)"name", (Object)this.name), writer);
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private String getIssueKeysList(SearchRequest searchRequest, SearchRequestParams searchRequestParams) {
        StringWriter issueKeys = new StringWriter();
        SingleIssueWriter singleIssueWriter = new SingleIssueWriter(){

            public void writeIssue(Issue issue, AbstractIssueView issueView, Writer writer) throws IOException {
                writer.write(issue.getKey());
                writer.write(",");
            }
        };
        try {
            this.searchRequestViewBodyWriterUtil.writeBody((Writer)issueKeys, null, searchRequest, singleIssueWriter, searchRequestParams.getPagerFilter());
        }
        catch (IOException e1) {
            throw new DataAccessException((Throwable)e1);
        }
        catch (SearchException e1) {
            throw new DataAccessException((Throwable)e1);
        }
        String issueKeysValue = issueKeys.toString();
        issueKeysValue = issueKeysValue.substring(0, issueKeysValue.length() - 1);
        return issueKeysValue;
    }

    private long getSearchCount(SearchRequest searchRequest, SearchRequestParams searchRequestParams) {
        String searchCount = (String)searchRequestParams.getSession().get("searchCount");
        if (StringUtils.isNumeric((String)searchCount)) {
            return Long.parseLong(searchCount);
        }
        try {
            return this.searchRequestViewBodyWriterUtil.searchCount(searchRequest);
        }
        catch (SearchException se) {
            return 0L;
        }
    }
}

