/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.module.jira;

import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptor;
import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptorImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.connect.plugin.integration.plugins.DescriptorToRegister;
import com.atlassian.plugin.connect.plugin.integration.plugins.DynamicDescriptorRegistration;
import com.atlassian.plugin.connect.plugin.module.IFrameParamsImpl;
import com.atlassian.plugin.connect.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.connect.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.connect.spi.module.IFrameParams;
import com.atlassian.plugin.connect.spi.module.IFrameViewProfilePanel;
import com.atlassian.plugin.connect.spi.util.Dom4jUtils;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.dom4j.Element;

public class JiraProfileTabModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private final DynamicDescriptorRegistration dynamicDescriptorRegistration;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IFrameRendererImpl iFrameRenderer;
    private Element descriptor;
    private URI url;
    private DynamicDescriptorRegistration.Registration registration;

    public JiraProfileTabModuleDescriptor(ModuleFactory moduleFactory, DynamicDescriptorRegistration dynamicDescriptorRegistration, JiraAuthenticationContext jiraAuthenticationContext, IFrameRendererImpl iFrameRenderer) {
        super(moduleFactory);
        this.dynamicDescriptorRegistration = (DynamicDescriptorRegistration)Preconditions.checkNotNull((Object)dynamicDescriptorRegistration);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.iFrameRenderer = (IFrameRendererImpl)Preconditions.checkNotNull((Object)iFrameRenderer);
    }

    public Void getModule() {
        return null;
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.descriptor = element;
        this.url = Dom4jUtils.getRequiredUriAttribute(element, "url");
    }

    public void enabled() {
        super.enabled();
        this.registration = this.dynamicDescriptorRegistration.registerDescriptors(this.getPlugin(), new DescriptorToRegister((ModuleDescriptor)this.createProfilePanelDescriptor(this.descriptor, this.getKey(), this.url)));
    }

    public void disabled() {
        super.disabled();
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    private ViewProfilePanelModuleDescriptor createProfilePanelDescriptor(final Element e, String key, final URI path) {
        String panelName = Dom4jUtils.getRequiredAttribute(e, "name");
        Element config = e.createCopy();
        final String moduleKey = "profile-" + key;
        config.addAttribute("key", moduleKey);
        config.addAttribute("system", "true");
        config.addAttribute("i18n-key", panelName);
        config.addAttribute("class", IFrameViewProfilePanel.class.getName());
        ViewProfilePanelModuleDescriptorImpl descriptor = new ViewProfilePanelModuleDescriptorImpl(this.jiraAuthenticationContext, new ModuleFactory(){

            public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
                return (T)new IFrameViewProfilePanel(JiraProfileTabModuleDescriptor.this.iFrameRenderer, new IFrameContextImpl(JiraProfileTabModuleDescriptor.this.getPluginKey(), path, moduleKey, (IFrameParams)new IFrameParamsImpl(e)));
            }
        });
        descriptor.init(this.getPlugin(), config);
        return descriptor;
    }
}

