/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.module.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.connect.plugin.DefaultRemotablePluginAccessorFactory;
import com.atlassian.plugin.connect.plugin.module.confluence.AbstractRemoteMacro;
import com.atlassian.plugin.connect.plugin.module.confluence.MacroContentManager;
import com.atlassian.plugin.connect.plugin.module.confluence.MacroInstance;
import com.atlassian.plugin.connect.plugin.module.confluence.RemoteMacroInfo;
import com.atlassian.plugin.connect.spi.RemotablePluginAccessor;
import com.atlassian.plugin.connect.spi.http.HttpMethod;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageFormatMacro
extends AbstractRemoteMacro {
    private final URI remoteUrl;
    private final HttpMethod httpMethod;
    private final MacroContentManager macroContentManager;
    private final DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory;
    private final Logger log = LoggerFactory.getLogger(StorageFormatMacro.class);

    public StorageFormatMacro(RemoteMacroInfo remoteMacroInfo, MacroContentManager macroContentManager, DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory) {
        super(remotablePluginAccessorFactory, remoteMacroInfo);
        this.remotablePluginAccessorFactory = remotablePluginAccessorFactory;
        this.remoteUrl = remoteMacroInfo.getUrl();
        this.httpMethod = remoteMacroInfo.getHttpMethod();
        this.macroContentManager = macroContentManager;
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> parameters, String storageFormatBody, ConversionContext conversionContext) throws MacroExecutionException {
        RemotablePluginAccessor remotablePluginAccessor = this.remotablePluginAccessorFactory.get(this.remoteMacroInfo.getPluginKey());
        try {
            return this.macroContentManager.getStaticContent(new MacroInstance(conversionContext, this.remoteUrl, this.httpMethod, storageFormatBody, parameters, this.remoteMacroInfo.getRequestContextParameterFactory(), remotablePluginAccessor));
        }
        catch (Exception ex) {
            String exMessage = ex.getMessage();
            if (ex.getCause() != null && ex.getCause() instanceof SocketTimeoutException) {
                exMessage = "Timeout waiting for reply";
            }
            String message = "Error: Unable to retrieve macro content from Remotable Plugin '" + remotablePluginAccessor.getName() + "': " + exMessage;
            this.log.error(message + " on page '{}' for url '{}'", (Object)StringEscapeUtils.escapeHtml((String)conversionContext.getEntity().getTitle()), (Object)this.remoteUrl);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to retrieve content", (Throwable)ex);
            }
            return message;
        }
    }

    @Override
    public RemotablePluginAccessor getRemotablePluginAccessor(String pluginKey) {
        return this.remotablePluginAccessorFactory.get(pluginKey);
    }
}

