/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.connect.plugin.module.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.connect.plugin.DefaultRemotablePluginAccessorFactory;
import com.atlassian.plugin.connect.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.connect.plugin.module.confluence.AbstractRemoteMacro;
import com.atlassian.plugin.connect.plugin.module.confluence.MacroInstance;
import com.atlassian.plugin.connect.plugin.module.confluence.RemoteMacroInfo;
import com.atlassian.plugin.connect.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.connect.spi.RemotablePluginAccessor;
import com.atlassian.plugin.connect.spi.module.IFrameContext;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;

public final class PageMacro
extends AbstractRemoteMacro {
    private final UserManager userManager;
    private final IFrameContext iframeContext;
    private final IFrameRendererImpl iFrameRenderer;
    private final DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory;

    public PageMacro(RemoteMacroInfo remoteMacroInfo, UserManager userManager, IFrameRendererImpl iFrameRenderer, IFrameContext iframeContext, DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory) {
        super(remotablePluginAccessorFactory, remoteMacroInfo);
        this.userManager = userManager;
        this.iframeContext = iframeContext;
        this.iFrameRenderer = iFrameRenderer;
        this.remotablePluginAccessorFactory = remotablePluginAccessorFactory;
    }

    public String execute(Map<String, String> parameters, String storageFormatBody, ConversionContext conversionContext) throws MacroExecutionException {
        String remoteUser = this.userManager.getRemoteUsername();
        String counter = this.incrementCounter(conversionContext);
        try {
            MacroInstance macroInstance = new MacroInstance(conversionContext, this.remoteMacroInfo.getUrl(), this.remoteMacroInfo.getHttpMethod(), storageFormatBody, parameters, this.remoteMacroInfo.getRequestContextParameterFactory(), this.remotablePluginAccessorFactory.get(this.remoteMacroInfo.getPluginKey()));
            UserKey userKey = this.userManager.getRemoteUserKey();
            return this.iFrameRenderer.render(new IFrameContextImpl(this.iframeContext, "-" + counter), "", this.convertParams(macroInstance.getUrlParameters(this.userManager.getRemoteUsername(), userKey == null ? "" : userKey.getStringValue())), remoteUser);
        }
        catch (IOException e) {
            throw new MacroExecutionException((Throwable)e);
        }
    }

    private String incrementCounter(ConversionContext ctx) {
        String key = "__counter_" + this.iframeContext.getNamespace();
        Integer counter = (Integer)ctx.getProperty(key);
        counter = counter == null ? 0 : counter + 1;
        ctx.setProperty(key, (Object)counter);
        return counter.toString();
    }

    private Map<String, String[]> convertParams(Map<String, String> parameters) {
        return Maps.transformValues(parameters, (Function)new Function<String, String[]>(){

            public String[] apply(String from) {
                return new String[]{from};
            }
        });
    }

    @Override
    public RemotablePluginAccessor getRemotablePluginAccessor(String pluginKey) {
        return this.remotablePluginAccessorFactory.get(pluginKey);
    }
}

